/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.condition.engine;

import com.cedarsoftware.util.CaseInsensitiveSet;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.available.WhereContextAvailable;
import org.apache.shardingsphere.infra.binder.context.extractor.SQLStatementContextExtractor;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.SchemaNotFoundException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.TableNotFoundException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.HashColumn;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.sharding.exception.data.ShardingValueDataTypeException;
import org.apache.shardingsphere.sharding.route.engine.condition.AlwaysFalseShardingCondition;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingCondition;
import org.apache.shardingsphere.sharding.route.engine.condition.generator.ConditionValueGeneratorFactory;
import org.apache.shardingsphere.sharding.route.engine.condition.value.AlwaysFalseShardingConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ListShardingConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.value.RangeShardingConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ShardingConditionValue;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.util.ShardingValueTypeConvertUtils;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.ColumnExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.ExpressionExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.statement.core.util.SafeNumberOperationUtils;
import org.apache.shardingsphere.timeservice.core.rule.TimestampServiceRule;

public final class WhereClauseShardingConditionEngine {
    private final ShardingSphereDatabase database;
    private final ShardingRule rule;
    private final TimestampServiceRule timestampServiceRule;

    public List<ShardingCondition> createShardingConditions(SQLStatementContext sqlStatementContext, List<Object> params) {
        if (!(sqlStatementContext instanceof WhereContextAvailable)) {
            return Collections.emptyList();
        }
        ArrayList<ShardingCondition> result = new ArrayList<ShardingCondition>();
        for (WhereSegment each : SQLStatementContextExtractor.getAllWhereSegments((SQLStatementContext)sqlStatementContext)) {
            result.addAll(this.createShardingConditions(each.getExpr(), params));
        }
        return result;
    }

    private Collection<ShardingCondition> createShardingConditions(ExpressionSegment expression, List<Object> params) {
        Collection andPredicates = ExpressionExtractor.extractAndPredicates((ExpressionSegment)expression);
        LinkedList<ShardingCondition> result = new LinkedList<ShardingCondition>();
        for (AndPredicate each : andPredicates) {
            Map<HashColumn, Collection<ShardingConditionValue>> shardingConditionValues = this.createShardingConditionValueMap(each.getPredicates(), params);
            if (shardingConditionValues.isEmpty()) {
                return Collections.emptyList();
            }
            ShardingCondition shardingCondition = this.createShardingCondition(shardingConditionValues);
            shardingCondition.setStartIndex(expression.getStartIndex());
            result.add(shardingCondition);
        }
        return result;
    }

    private Map<HashColumn, Collection<ShardingConditionValue>> createShardingConditionValueMap(Collection<ExpressionSegment> predicates, List<Object> params) {
        HashMap<HashColumn, Collection<ShardingConditionValue>> result = new HashMap<HashColumn, Collection<ShardingConditionValue>>(predicates.size(), 1.0f);
        for (ExpressionSegment each : predicates) {
            for (ColumnSegment columnSegment : ColumnExtractor.extract((ExpressionSegment)each)) {
                String tableName = columnSegment.getColumnBoundInfo().getOriginalTable().getValue();
                Optional<String> shardingColumn = this.rule.findShardingColumn(columnSegment.getColumnBoundInfo().getOriginalColumn().getValue(), tableName);
                if (!shardingColumn.isPresent()) continue;
                String schemaName = columnSegment.getColumnBoundInfo().getOriginalSchema().getValue();
                ShardingSpherePreconditions.checkState((boolean)this.database.containsSchema(schemaName), () -> new SchemaNotFoundException(schemaName));
                ShardingSphereSchema schema = this.database.getSchema(schemaName);
                ShardingSpherePreconditions.checkState((boolean)schema.containsTable(tableName), () -> new TableNotFoundException(tableName));
                HashColumn column = new HashColumn(shardingColumn.get(), tableName, schema.getTable(tableName).getColumn(shardingColumn.get()).isCaseSensitive());
                Optional<ShardingConditionValue> shardingConditionValue = ConditionValueGeneratorFactory.generate(each, column, params, this.timestampServiceRule);
                if (!shardingConditionValue.isPresent()) continue;
                result.computeIfAbsent(column, unused -> new LinkedList()).add(shardingConditionValue.get());
            }
        }
        return result;
    }

    private ShardingCondition createShardingCondition(Map<HashColumn, Collection<ShardingConditionValue>> shardingConditionValues) {
        ShardingCondition result = new ShardingCondition();
        for (Map.Entry<HashColumn, Collection<ShardingConditionValue>> entry : shardingConditionValues.entrySet()) {
            try {
                ShardingConditionValue shardingConditionValue = this.mergeShardingConditionValues(entry.getKey(), entry.getValue());
                if (shardingConditionValue instanceof AlwaysFalseShardingConditionValue) {
                    return new AlwaysFalseShardingCondition();
                }
                result.getValues().add(shardingConditionValue);
            }
            catch (ClassCastException ignored) {
                throw new ShardingValueDataTypeException(entry.getKey());
            }
        }
        return result;
    }

    private ShardingConditionValue mergeShardingConditionValues(HashColumn column, Collection<ShardingConditionValue> shardingConditionValues) {
        Collection<Comparable<?>> listValue = null;
        Range<Comparable<?>> rangeValue = null;
        HashSet<Integer> parameterMarkerIndexes = new HashSet<Integer>();
        for (ShardingConditionValue each : shardingConditionValues) {
            parameterMarkerIndexes.addAll(each.getParameterMarkerIndexes());
            if (each instanceof ListShardingConditionValue) {
                listValue = this.mergeListShardingValues(column, ((ListShardingConditionValue)each).getValues(), listValue);
                if (!listValue.isEmpty()) continue;
                return new AlwaysFalseShardingConditionValue();
            }
            if (!(each instanceof RangeShardingConditionValue)) continue;
            try {
                rangeValue = this.mergeRangeShardingValues(((RangeShardingConditionValue)each).getValueRange(), rangeValue);
            }
            catch (IllegalArgumentException ex) {
                return new AlwaysFalseShardingConditionValue();
            }
        }
        if (null == listValue) {
            return new RangeShardingConditionValue(column.getName(), column.getTableName(), rangeValue, new ArrayList<Integer>(parameterMarkerIndexes));
        }
        if (null == rangeValue) {
            return new ListShardingConditionValue(column.getName(), column.getTableName(), listValue, new ArrayList<Integer>(parameterMarkerIndexes));
        }
        return (listValue = this.mergeListAndRangeShardingValues(listValue, rangeValue)).isEmpty() ? new AlwaysFalseShardingConditionValue() : new ListShardingConditionValue(column.getName(), column.getTableName(), listValue, new ArrayList<Integer>(parameterMarkerIndexes));
    }

    private Collection<Comparable<?>> mergeListShardingValues(HashColumn column, Collection<Comparable<?>> value1, Collection<Comparable<?>> value2) {
        if (null == value2) {
            return value1;
        }
        Collection<Comparable<?>> convertedValue2 = value2;
        if (!value1.isEmpty() && !value2.isEmpty() && this.isDifferentType(value1, value2)) {
            convertedValue2 = ShardingValueTypeConvertUtils.convertCollectionType(value2, value1.iterator().next().getClass());
        }
        if (column.isCaseSensitive()) {
            value1.retainAll(convertedValue2);
            return value1;
        }
        CaseInsensitiveSet caseInSensitiveValue1 = new CaseInsensitiveSet(value1);
        CaseInsensitiveSet caseInSensitiveValue2 = new CaseInsensitiveSet(convertedValue2);
        caseInSensitiveValue1.retainAll((Collection<?>)caseInSensitiveValue2);
        return caseInSensitiveValue1;
    }

    private boolean isDifferentType(Collection<Comparable<?>> value1, Collection<Comparable<?>> value2) {
        return value1.iterator().next().getClass() != value2.iterator().next().getClass();
    }

    private Range<Comparable<?>> mergeRangeShardingValues(Range<Comparable<?>> value1, Range<Comparable<?>> value2) {
        return null == value2 ? value1 : SafeNumberOperationUtils.safeIntersection(value1, value2);
    }

    private Collection<Comparable<?>> mergeListAndRangeShardingValues(Collection<Comparable<?>> listValue, Range<Comparable<?>> rangeValue) {
        LinkedList result = new LinkedList();
        for (Comparable<?> each : listValue) {
            if (!SafeNumberOperationUtils.safeContains(rangeValue, each)) continue;
            result.add(each);
        }
        return result;
    }

    @Generated
    public WhereClauseShardingConditionEngine(ShardingSphereDatabase database, ShardingRule rule, TimestampServiceRule timestampServiceRule) {
        this.database = database;
        this.rule = rule;
        this.timestampServiceRule = timestampServiceRule;
    }
}

