/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.manager;

import lombok.Generated;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstanceContext;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.manager.database.DatabaseMetaDataManager;
import org.apache.shardingsphere.mode.metadata.manager.resource.ResourceSwitchManager;
import org.apache.shardingsphere.mode.metadata.manager.resource.StorageUnitManager;
import org.apache.shardingsphere.mode.metadata.manager.rule.DatabaseRuleConfigurationManager;
import org.apache.shardingsphere.mode.metadata.manager.rule.DatabaseRuleItemManager;
import org.apache.shardingsphere.mode.metadata.manager.rule.GlobalConfigurationManager;
import org.apache.shardingsphere.mode.metadata.manager.statistics.StatisticsManager;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistFacade;
import org.apache.shardingsphere.mode.spi.repository.PersistRepository;

public class MetaDataContextManager {
    private final MetaDataContexts metaDataContexts;
    private final ComputeNodeInstanceContext computeNodeInstanceContext;
    private final MetaDataPersistFacade metaDataPersistFacade;
    private final StatisticsManager statisticsManager;
    private final DatabaseMetaDataManager databaseMetaDataManager;
    private final DatabaseRuleItemManager databaseRuleItemManager;
    private final ResourceSwitchManager resourceSwitchManager;
    private final StorageUnitManager storageUnitManager;
    private final DatabaseRuleConfigurationManager databaseRuleConfigurationManager;
    private final GlobalConfigurationManager globalConfigurationManager;

    public MetaDataContextManager(MetaDataContexts metaDataContexts, ComputeNodeInstanceContext computeNodeInstanceContext, PersistRepository repository) {
        this.metaDataContexts = metaDataContexts;
        this.computeNodeInstanceContext = computeNodeInstanceContext;
        this.metaDataPersistFacade = new MetaDataPersistFacade(repository, (Boolean)metaDataContexts.getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.PERSIST_SCHEMAS_TO_REPOSITORY_ENABLED));
        this.resourceSwitchManager = new ResourceSwitchManager();
        this.statisticsManager = new StatisticsManager(metaDataContexts);
        this.storageUnitManager = new StorageUnitManager(metaDataContexts, computeNodeInstanceContext, this.resourceSwitchManager, this.metaDataPersistFacade);
        this.databaseRuleConfigurationManager = new DatabaseRuleConfigurationManager(metaDataContexts, computeNodeInstanceContext, this.metaDataPersistFacade);
        this.databaseMetaDataManager = new DatabaseMetaDataManager(metaDataContexts, this.metaDataPersistFacade);
        this.databaseRuleItemManager = new DatabaseRuleItemManager(metaDataContexts, this.databaseRuleConfigurationManager, this.metaDataPersistFacade);
        this.globalConfigurationManager = new GlobalConfigurationManager(metaDataContexts, this.metaDataPersistFacade);
    }

    @Generated
    public MetaDataContexts getMetaDataContexts() {
        return this.metaDataContexts;
    }

    @Generated
    public ComputeNodeInstanceContext getComputeNodeInstanceContext() {
        return this.computeNodeInstanceContext;
    }

    @Generated
    public MetaDataPersistFacade getMetaDataPersistFacade() {
        return this.metaDataPersistFacade;
    }

    @Generated
    public StatisticsManager getStatisticsManager() {
        return this.statisticsManager;
    }

    @Generated
    public DatabaseMetaDataManager getDatabaseMetaDataManager() {
        return this.databaseMetaDataManager;
    }

    @Generated
    public DatabaseRuleItemManager getDatabaseRuleItemManager() {
        return this.databaseRuleItemManager;
    }

    @Generated
    public ResourceSwitchManager getResourceSwitchManager() {
        return this.resourceSwitchManager;
    }

    @Generated
    public StorageUnitManager getStorageUnitManager() {
        return this.storageUnitManager;
    }

    @Generated
    public DatabaseRuleConfigurationManager getDatabaseRuleConfigurationManager() {
        return this.databaseRuleConfigurationManager;
    }

    @Generated
    public GlobalConfigurationManager getGlobalConfigurationManager() {
        return this.globalConfigurationManager;
    }
}

