/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rewrite.sql.token.keygen.generator;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.insert.keygen.GeneratedKeyContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.aware.ParametersAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.keygen.generator.BaseGeneratedKeyTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.keygen.pojo.GeneratedKeyAssignmentToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.keygen.pojo.LiteralGeneratedKeyAssignmentToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.keygen.pojo.ParameterMarkerGeneratedKeyAssignmentToken;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.SetAssignmentSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.InsertStatement;

public final class GeneratedKeyAssignmentTokenGenerator
extends BaseGeneratedKeyTokenGenerator
implements ParametersAware {
    private List<Object> parameters;

    @Override
    protected boolean isGenerateSQLToken(InsertStatementContext insertStatementContext) {
        return insertStatementContext.getSqlStatement().getSetAssignment().isPresent();
    }

    public GeneratedKeyAssignmentToken generateSQLToken(InsertStatementContext insertStatementContext) {
        Optional generatedKey = insertStatementContext.getGeneratedKeyContext();
        Preconditions.checkState((boolean)generatedKey.isPresent());
        InsertStatement insertStatement = insertStatementContext.getSqlStatement();
        Preconditions.checkState((boolean)insertStatement.getSetAssignment().isPresent());
        int startIndex = ((SetAssignmentSegment)insertStatement.getSetAssignment().get()).getStopIndex() + 1;
        return this.parameters.isEmpty() ? new LiteralGeneratedKeyAssignmentToken(startIndex, ((GeneratedKeyContext)generatedKey.get()).getColumnName(), ((GeneratedKeyContext)generatedKey.get()).getGeneratedValues().iterator().next()) : new ParameterMarkerGeneratedKeyAssignmentToken(startIndex, ((GeneratedKeyContext)generatedKey.get()).getColumnName());
    }

    @Override
    @Generated
    public void setParameters(List<Object> parameters) {
        this.parameters = parameters;
    }
}

