/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.segment.select.projection.extractor;

import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.database.enums.QuoteCharacter;
import org.apache.shardingsphere.database.connector.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.extractor.DialectProjectionIdentifierExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.SubqueryProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class ProjectionIdentifierExtractEngine {
    private final DatabaseType databaseType;

    public String getIdentifierValue(IdentifierValue identifierValue) {
        if (QuoteCharacter.NONE != identifierValue.getQuoteCharacter()) {
            return identifierValue.getValue();
        }
        return DatabaseTypedSPILoader.findService(DialectProjectionIdentifierExtractor.class, (DatabaseType)this.databaseType).map(optional -> optional.getIdentifierValue(identifierValue)).orElseGet(() -> ((IdentifierValue)identifierValue).getValue());
    }

    public String getColumnNameFromFunction(String functionName, String functionExpression) {
        return DatabaseTypedSPILoader.findService(DialectProjectionIdentifierExtractor.class, (DatabaseType)this.databaseType).map(optional -> optional.getColumnNameFromFunction(functionName, functionExpression)).orElse(functionExpression);
    }

    public String getColumnNameFromExpression(ExpressionSegment expressionSegment) {
        return DatabaseTypedSPILoader.findService(DialectProjectionIdentifierExtractor.class, (DatabaseType)this.databaseType).map(optional -> optional.getColumnNameFromExpression(expressionSegment)).orElse(expressionSegment.getText());
    }

    public String getColumnNameFromSubquery(SubqueryProjectionSegment subquerySegment) {
        return DatabaseTypedSPILoader.findService(DialectProjectionIdentifierExtractor.class, (DatabaseType)this.databaseType).map(optional -> optional.getColumnNameFromSubquery(subquerySegment)).orElseGet(() -> ((SubqueryProjectionSegment)subquerySegment).getText());
    }

    @Generated
    public ProjectionIdentifierExtractEngine(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }
}

