/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.resource.unit;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.exception.UnrecognizedDatabaseURLException;
import org.apache.shardingsphere.database.connector.core.jdbcurl.parser.ConnectionProperties;
import org.apache.shardingsphere.database.connector.core.jdbcurl.parser.ConnectionPropertiesParser;
import org.apache.shardingsphere.database.connector.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeFactory;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.metadata.database.resource.node.StorageNode;

public final class StorageUnitNodeMapCreator {
    public static Map<String, StorageNode> create(Map<String, DataSourcePoolProperties> propsMap, boolean isInstanceConnectionEnabled) {
        return propsMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> StorageUnitNodeMapCreator.create((String)entry.getKey(), (DataSourcePoolProperties)entry.getValue(), isInstanceConnectionEnabled), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    private static StorageNode create(String storageUnitName, DataSourcePoolProperties props, boolean isInstanceConnectionEnabled) {
        Map standardProps = props.getConnectionPropertySynonyms().getStandardProperties();
        String url = standardProps.get("url").toString();
        String username = standardProps.get("username").toString();
        boolean isInstanceConnectionAvailable = new DatabaseTypeRegistry(DatabaseTypeFactory.get((String)url)).getDialectDatabaseMetaData().getConnectionOption().isInstanceConnectionAvailable();
        try {
            ConnectionProperties connectionProps = ((ConnectionPropertiesParser)DatabaseTypedSPILoader.getService(ConnectionPropertiesParser.class, (DatabaseType)DatabaseTypeFactory.get((String)url))).parse(url, username, null);
            return isInstanceConnectionEnabled && isInstanceConnectionAvailable ? new StorageNode(connectionProps.getHostname(), connectionProps.getPort(), username) : new StorageNode(storageUnitName);
        }
        catch (UnrecognizedDatabaseURLException ex) {
            return new StorageNode(storageUnitName);
        }
    }

    @Generated
    private StorageUnitNodeMapCreator() {
    }
}

