/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mask.checker;

import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.algorithm.core.exception.UnregisteredAlgorithmException;
import org.apache.shardingsphere.infra.config.rule.checker.DatabaseRuleConfigurationChecker;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.external.sql.identifier.SQLExceptionIdentifier;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.mask.config.MaskRuleConfiguration;
import org.apache.shardingsphere.mask.config.rule.MaskColumnRuleConfiguration;
import org.apache.shardingsphere.mask.config.rule.MaskTableRuleConfiguration;
import org.apache.shardingsphere.mask.spi.MaskAlgorithm;

public final class MaskRuleConfigurationChecker
implements DatabaseRuleConfigurationChecker<MaskRuleConfiguration> {
    public void check(String databaseName, MaskRuleConfiguration ruleConfig, Map<String, DataSource> dataSourceMap, Collection<ShardingSphereRule> builtRules) {
        this.checkMaskAlgorithms(ruleConfig.getMaskAlgorithms());
        this.checkTables(databaseName, ruleConfig.getTables(), ruleConfig.getMaskAlgorithms());
    }

    private void checkMaskAlgorithms(Map<String, AlgorithmConfiguration> maskAlgorithms) {
        maskAlgorithms.values().forEach(each -> TypedSPILoader.checkService(MaskAlgorithm.class, (Object)each.getType(), (Properties)each.getProps()));
    }

    private void checkTables(String databaseName, Collection<MaskTableRuleConfiguration> tables, Map<String, AlgorithmConfiguration> maskAlgorithms) {
        tables.forEach(each -> this.checkColumns(databaseName, (MaskTableRuleConfiguration)each, maskAlgorithms));
    }

    private void checkColumns(String databaseName, MaskTableRuleConfiguration tableRuleConfig, Map<String, AlgorithmConfiguration> maskAlgorithms) {
        tableRuleConfig.getColumns().forEach(each -> this.checkColumn(databaseName, tableRuleConfig.getName(), (MaskColumnRuleConfiguration)each, maskAlgorithms));
    }

    private void checkColumn(String databaseName, String tableName, MaskColumnRuleConfiguration columnRuleConfig, Map<String, AlgorithmConfiguration> maskAlgorithms) {
        ShardingSpherePreconditions.checkContainsKey(maskAlgorithms, (Object)columnRuleConfig.getMaskAlgorithm(), () -> new UnregisteredAlgorithmException("Mask", columnRuleConfig.getMaskAlgorithm(), new SQLExceptionIdentifier(databaseName, tableName, columnRuleConfig.getLogicColumn())));
    }

    public Collection<String> getTableNames(MaskRuleConfiguration ruleConfig) {
        return ruleConfig.getTables().stream().map(MaskTableRuleConfiguration::getName).collect(Collectors.toList());
    }

    public int getOrder() {
        return 30;
    }

    public Class<MaskRuleConfiguration> getTypeClass() {
        return MaskRuleConfiguration.class;
    }
}

