/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.traces;

import java.io.IOException;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.MarshalerContext;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.Serializer;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.StatelessMarshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.StatelessMarshalerUtil;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.AttributeKeyValueStatelessMarshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.proto.trace.v1.internal.Span;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.data.EventData;

final class SpanEventStatelessMarshaler
implements StatelessMarshaler<EventData> {
    static final SpanEventStatelessMarshaler INSTANCE = new SpanEventStatelessMarshaler();

    private SpanEventStatelessMarshaler() {
    }

    @Override
    public void writeTo(Serializer output, EventData event, MarshalerContext context) throws IOException {
        output.serializeFixed64(Span.Event.TIME_UNIX_NANO, event.getEpochNanos());
        output.serializeStringWithContext(Span.Event.NAME, event.getName(), context);
        output.serializeRepeatedMessageWithContext(Span.Event.ATTRIBUTES, event.getAttributes(), AttributeKeyValueStatelessMarshaler.INSTANCE, context);
        int droppedAttributesCount = event.getTotalAttributeCount() - event.getAttributes().size();
        output.serializeUInt32(Span.Event.DROPPED_ATTRIBUTES_COUNT, droppedAttributesCount);
    }

    @Override
    public int getBinarySerializedSize(EventData event, MarshalerContext context) {
        int size = 0;
        size += MarshalerUtil.sizeFixed64(Span.Event.TIME_UNIX_NANO, event.getEpochNanos());
        size += StatelessMarshalerUtil.sizeStringWithContext(Span.Event.NAME, event.getName(), context);
        size += StatelessMarshalerUtil.sizeRepeatedMessageWithContext(Span.Event.ATTRIBUTES, event.getAttributes(), AttributeKeyValueStatelessMarshaler.INSTANCE, context);
        int droppedAttributesCount = event.getTotalAttributeCount() - event.getAttributes().size();
        return size += MarshalerUtil.sizeUInt32(Span.Event.DROPPED_ATTRIBUTES_COUNT, droppedAttributesCount);
    }
}

