/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.datasource.creator;

import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.shardingsphere.authority.yaml.config.YamlAuthorityRuleConfiguration;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContextManager;
import org.apache.shardingsphere.data.pipeline.core.datasource.yaml.PipelineYamlRuleConfigurationReviser;
import org.apache.shardingsphere.data.pipeline.spi.PipelineDataSourceCreator;
import org.apache.shardingsphere.driver.api.ShardingSphereDataSourceFactory;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.config.props.temporary.TemporaryConfigurationPropertyKey;
import org.apache.shardingsphere.infra.datasource.pool.destroyer.DataSourcePoolDestroyer;
import org.apache.shardingsphere.infra.spi.type.ordered.OrderedSPILoader;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.config.pojo.YamlRootConfiguration;
import org.apache.shardingsphere.infra.yaml.config.pojo.mode.YamlModeConfiguration;
import org.apache.shardingsphere.infra.yaml.config.pojo.mode.YamlPersistRepositoryConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.mode.YamlModeConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.config.swapper.resource.YamlDataSourceConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapperEngine;
import org.apache.shardingsphere.mode.manager.ContextManager;

public final class ShardingSpherePipelineDataSourceCreator
implements PipelineDataSourceCreator {
    public DataSource create(Object dataSourceConfig) throws SQLException {
        YamlRootConfiguration yamlRootConfig = (YamlRootConfiguration)YamlEngine.unmarshal((String)YamlEngine.marshal((Object)dataSourceConfig), YamlRootConfiguration.class);
        this.removeAuthorityRuleConfiguration(yamlRootConfig);
        yamlRootConfig.setProps(this.createConfigurationProperties());
        this.reviseYamlRuleConfiguration(yamlRootConfig);
        yamlRootConfig.setMode(this.createStandaloneModeConfiguration());
        return this.createShardingSphereDataSource(yamlRootConfig);
    }

    private void removeAuthorityRuleConfiguration(YamlRootConfiguration yamlRootConfig) {
        yamlRootConfig.getRules().removeIf(YamlAuthorityRuleConfiguration.class::isInstance);
    }

    private Properties createConfigurationProperties() {
        Properties realtimeProps = this.getRealtimeProperties();
        Properties result = new Properties();
        for (String each : this.getConfigurationPropertyKeys()) {
            Object value = realtimeProps.get(each);
            if (null == value) continue;
            result.put(each, value);
        }
        result.put(TemporaryConfigurationPropertyKey.SYSTEM_SCHEMA_METADATA_ASSEMBLY_ENABLED.getKey(), String.valueOf(Boolean.FALSE));
        result.put(ConfigurationPropertyKey.MAX_CONNECTIONS_SIZE_PER_QUERY.getKey(), (Object)100000);
        return result;
    }

    private Properties getRealtimeProperties() {
        ContextManager contextManager = PipelineContextManager.getProxyContext();
        if (null == contextManager) {
            return new Properties();
        }
        return contextManager.getMetaDataContexts().getMetaData().getProps().getProps();
    }

    private List<String> getConfigurationPropertyKeys() {
        LinkedList<String> result = new LinkedList<String>();
        result.add(ConfigurationPropertyKey.KERNEL_EXECUTOR_SIZE.getKey());
        result.add(ConfigurationPropertyKey.SQL_SHOW.getKey());
        return result;
    }

    private void reviseYamlRuleConfiguration(YamlRootConfiguration yamlRootConfig) {
        OrderedSPILoader.getServices(PipelineYamlRuleConfigurationReviser.class, (Collection)yamlRootConfig.getRules()).forEach((key, value) -> value.revise(key));
    }

    private YamlModeConfiguration createStandaloneModeConfiguration() {
        YamlModeConfiguration result = new YamlModeConfiguration();
        result.setType("Standalone");
        YamlPersistRepositoryConfiguration yamlRepositoryConfig = new YamlPersistRepositoryConfiguration();
        yamlRepositoryConfig.setType("Memory");
        result.setRepository(yamlRepositoryConfig);
        return result;
    }

    private DataSource createShardingSphereDataSource(YamlRootConfiguration yamlRootConfig) throws SQLException {
        Map dataSourceMap = new YamlDataSourceConfigurationSwapper().swapToDataSources(yamlRootConfig.getDataSources(), false);
        try {
            return this.createShardingSphereDataSource(dataSourceMap, yamlRootConfig);
        }
        catch (RuntimeException | SQLException ex) {
            dataSourceMap.values().stream().map(DataSourcePoolDestroyer::new).forEach(DataSourcePoolDestroyer::asyncDestroy);
            throw ex;
        }
    }

    private DataSource createShardingSphereDataSource(Map<String, DataSource> dataSourceMap, YamlRootConfiguration yamlRootConfig) throws SQLException {
        ModeConfiguration modeConfig = new YamlModeConfigurationSwapper().swapToObject(yamlRootConfig.getMode());
        Collection ruleConfigs = new YamlRuleConfigurationSwapperEngine().swapToRuleConfigurations(yamlRootConfig.getRules());
        return ShardingSphereDataSourceFactory.createDataSource((String)yamlRootConfig.getDatabaseName(), (ModeConfiguration)modeConfig, dataSourceMap, (Collection)ruleConfigs, (Properties)yamlRootConfig.getProps());
    }

    public String getType() {
        return "ShardingSphereJDBC";
    }
}

