/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.job.progress.yaml.swapper;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.type.finished.IngestFinishedPosition;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.type.pk.UniqueKeyIngestPosition;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.type.placeholder.IngestPlaceholderPosition;
import org.apache.shardingsphere.data.pipeline.core.job.progress.JobItemInventoryTasksProgress;
import org.apache.shardingsphere.data.pipeline.core.job.progress.yaml.config.YamlJobItemInventoryTasksProgress;
import org.apache.shardingsphere.data.pipeline.core.task.progress.InventoryTaskProgress;

public final class YamlJobItemInventoryTasksProgressSwapper {
    public YamlJobItemInventoryTasksProgress swapToYaml(JobItemInventoryTasksProgress progress) {
        YamlJobItemInventoryTasksProgress result = new YamlJobItemInventoryTasksProgress();
        if (null != progress) {
            result.setFinished(this.getFinished(progress));
            result.setUnfinished(this.getUnfinished(progress));
        }
        return result;
    }

    private String[] getFinished(JobItemInventoryTasksProgress progress) {
        return (String[])progress.getProgresses().entrySet().stream().filter(entry -> ((InventoryTaskProgress)entry.getValue()).getPosition() instanceof IngestFinishedPosition).map(Map.Entry::getKey).toArray(String[]::new);
    }

    private Map<String, String> getUnfinished(JobItemInventoryTasksProgress progress) {
        return progress.getProgresses().entrySet().stream().filter(entry -> !(((InventoryTaskProgress)entry.getValue()).getPosition() instanceof IngestFinishedPosition)).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((InventoryTaskProgress)entry.getValue()).getPosition().toString()));
    }

    public JobItemInventoryTasksProgress swapToObject(YamlJobItemInventoryTasksProgress yamlProgress) {
        if (null == yamlProgress) {
            return new JobItemInventoryTasksProgress(Collections.emptyMap());
        }
        LinkedHashMap<String, InventoryTaskProgress> taskProgressMap = new LinkedHashMap<String, InventoryTaskProgress>(yamlProgress.getFinished().length + yamlProgress.getUnfinished().size(), 1.0f);
        taskProgressMap.putAll(Arrays.stream(yamlProgress.getFinished()).collect(Collectors.toMap(key -> key, value -> new InventoryTaskProgress(new IngestFinishedPosition()))));
        taskProgressMap.putAll(yamlProgress.getUnfinished().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, this.getInventoryTaskProgressFunction())));
        return new JobItemInventoryTasksProgress(taskProgressMap);
    }

    private Function<Map.Entry<String, String>, InventoryTaskProgress> getInventoryTaskProgressFunction() {
        return entry -> new InventoryTaskProgress(Strings.isNullOrEmpty((String)((String)entry.getValue())) ? new IngestPlaceholderPosition() : UniqueKeyIngestPosition.decode((String)entry.getValue()));
    }
}

