/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.listener;

import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContextKey;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContextManager;
import org.apache.shardingsphere.data.pipeline.core.exception.job.PipelineJobNotFoundException;
import org.apache.shardingsphere.data.pipeline.core.job.api.PipelineAPIFactory;
import org.apache.shardingsphere.data.pipeline.core.job.id.PipelineJobIdUtils;
import org.apache.shardingsphere.data.pipeline.core.job.service.PipelineJobManager;
import org.apache.shardingsphere.data.pipeline.core.job.type.PipelineJobType;
import org.apache.shardingsphere.data.pipeline.core.metadata.node.PipelineMetaDataNodeWatcher;
import org.apache.shardingsphere.elasticjob.infra.listener.ElasticJobListener;
import org.apache.shardingsphere.elasticjob.infra.pojo.JobConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.infra.spi.ElasticJobServiceLoader;
import org.apache.shardingsphere.elasticjob.lite.lifecycle.api.JobConfigurationAPI;
import org.apache.shardingsphere.elasticjob.lite.lifecycle.domain.JobBriefInfo;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.listener.ContextManagerLifecycleListener;
import org.apache.shardingsphere.mode.manager.listener.ContextManagerLifecycleListenerModeRequired;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ContextManagerLifecycleListenerModeRequired(value="Cluster")
public final class PipelineContextManagerLifecycleListener
implements ContextManagerLifecycleListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PipelineContextManagerLifecycleListener.class);

    public void onInitialized(ContextManager contextManager) {
        String preSelectedDatabaseName = contextManager.getPreSelectedDatabaseName();
        if ("logic_db".equals(preSelectedDatabaseName)) {
            return;
        }
        PipelineContextKey contextKey = new PipelineContextKey(preSelectedDatabaseName, contextManager.getComputeNodeInstanceContext().getInstance().getMetaData().getType());
        PipelineContextManager.putContext(contextKey, contextManager);
        PipelineMetaDataNodeWatcher.init(contextKey);
        ElasticJobServiceLoader.registerTypedService(ElasticJobListener.class);
        try {
            this.dispatchEnablePipelineJobStartEvent(contextKey);
        }
        catch (RuntimeException ex) {
            log.error("Dispatch enable pipeline job start event failed", (Throwable)ex);
        }
    }

    private void dispatchEnablePipelineJobStartEvent(PipelineContextKey contextKey) {
        JobConfigurationAPI jobConfigAPI = PipelineAPIFactory.getJobConfigurationAPI(contextKey);
        List allJobsBriefInfo = PipelineAPIFactory.getJobStatisticsAPI(contextKey).getAllJobsBriefInfo().stream().filter(each -> !each.getJobName().startsWith("_")).collect(Collectors.toList());
        log.info("All job names: {}", (Object)allJobsBriefInfo.stream().map(JobBriefInfo::getJobName).collect(Collectors.joining(",")));
        for (JobBriefInfo each2 : allJobsBriefInfo) {
            JobConfigurationPOJO jobConfig;
            PipelineJobType jobType;
            try {
                jobType = PipelineJobIdUtils.parseJobType(each2.getJobName());
            }
            catch (IllegalArgumentException ex) {
                log.warn("Parse job type failed, job name: {}, error: {}", (Object)each2.getJobName(), (Object)ex.getMessage());
                continue;
            }
            if ("CONSISTENCY_CHECK".equals(jobType.getType())) continue;
            try {
                jobConfig = jobConfigAPI.getJobConfiguration(each2.getJobName());
            }
            catch (PipelineJobNotFoundException ex) {
                log.error("Get job configuration failed, job name: {}, error: {}", (Object)each2.getJobName(), (Object)ex.getMessage());
                continue;
            }
            if (jobConfig.isDisabled()) continue;
            new PipelineJobManager(jobType).resume(each2.getJobName());
            log.info("Dispatch enable pipeline job start event, job name: {}", (Object)each2.getJobName());
        }
    }

    public void onDestroyed(ContextManager contextManager) {
        PipelineContextManager.removeContext(new PipelineContextKey(contextManager.getPreSelectedDatabaseName(), contextManager.getComputeNodeInstanceContext().getInstance().getMetaData().getType()));
    }
}

