/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.metadata;

import com.google.common.base.Strings;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContextKey;
import org.apache.shardingsphere.data.pipeline.core.job.api.PipelineAPIFactory;
import org.apache.shardingsphere.data.pipeline.core.job.progress.config.PipelineProcessConfiguration;
import org.apache.shardingsphere.data.pipeline.core.job.progress.config.yaml.config.YamlPipelineProcessConfiguration;
import org.apache.shardingsphere.data.pipeline.core.job.progress.config.yaml.swapper.YamlPipelineProcessConfigurationSwapper;
import org.apache.shardingsphere.data.pipeline.core.metadata.PipelineMetaDataPersistService;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;

public final class PipelineProcessConfigurationPersistService
implements PipelineMetaDataPersistService<PipelineProcessConfiguration> {
    private final YamlPipelineProcessConfigurationSwapper swapper = new YamlPipelineProcessConfigurationSwapper();

    @Override
    public PipelineProcessConfiguration load(PipelineContextKey contextKey, String jobType) {
        String yamlText = PipelineAPIFactory.getPipelineGovernanceFacade(contextKey).getMetaDataFacade().getProcessConfiguration().load(jobType);
        if (Strings.isNullOrEmpty((String)yamlText)) {
            return null;
        }
        YamlPipelineProcessConfiguration yamlConfig = (YamlPipelineProcessConfiguration)YamlEngine.unmarshal((String)yamlText, YamlPipelineProcessConfiguration.class, (boolean)true);
        return this.swapper.swapToObject(yamlConfig);
    }

    @Override
    public void persist(PipelineContextKey contextKey, String jobType, PipelineProcessConfiguration processConfig) {
        String yamlText = YamlEngine.marshal((Object)this.swapper.swapToYamlConfiguration(processConfig));
        PipelineAPIFactory.getPipelineGovernanceFacade(contextKey).getMetaDataFacade().getProcessConfiguration().persist(jobType, yamlText);
    }
}

