/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.distsql.handler.checker;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.segment.AlgorithmSegment;
import org.apache.shardingsphere.infra.algorithm.core.exception.InvalidAlgorithmConfigurationException;
import org.apache.shardingsphere.infra.algorithm.loadbalancer.spi.LoadBalanceAlgorithm;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.resource.storageunit.MissingRequiredStorageUnitsException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.DuplicateRuleException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.InvalidRuleConfigurationException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.MissingRequiredRuleException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.MissingRequiredStrategyException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.ResourceMetaData;
import org.apache.shardingsphere.infra.rule.attribute.datasource.DataSourceMapperRuleAttribute;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.readwritesplitting.config.ReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.config.rule.ReadwriteSplittingDataSourceGroupRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.constant.ReadwriteSplittingDataSourceType;
import org.apache.shardingsphere.readwritesplitting.distsql.segment.ReadwriteSplittingRuleSegment;
import org.apache.shardingsphere.readwritesplitting.exception.ReadwriteSplittingRuleExceptionIdentifier;
import org.apache.shardingsphere.readwritesplitting.exception.actual.DuplicateReadwriteSplittingActualDataSourceException;
import org.apache.shardingsphere.readwritesplitting.transaction.TransactionalReadQueryStrategy;

public final class ReadwriteSplittingRuleStatementChecker {
    public static void checkCreation(ShardingSphereDatabase database, Collection<ReadwriteSplittingRuleSegment> segments, ReadwriteSplittingRuleConfiguration currentRuleConfig, boolean ifNotExists) {
        ReadwriteSplittingRuleStatementChecker.checkDuplicateRuleNames(database, segments, currentRuleConfig, ifNotExists);
        String databaseName = database.getName();
        ReadwriteSplittingRuleStatementChecker.checkDataSourcesExist(databaseName, segments, database);
        ReadwriteSplittingRuleStatementChecker.checkDuplicatedDataSourceNames(databaseName, segments, currentRuleConfig, true);
        ReadwriteSplittingRuleStatementChecker.checkTransactionalReadQueryStrategy(segments);
        ReadwriteSplittingRuleStatementChecker.checkLoadBalancers(segments);
    }

    public static void checkAlteration(ShardingSphereDatabase database, Collection<ReadwriteSplittingRuleSegment> segments, ReadwriteSplittingRuleConfiguration currentRuleConfig) {
        String databaseName = database.getName();
        ReadwriteSplittingRuleStatementChecker.checkDuplicateRuleNamesWithSelf(databaseName, segments);
        ReadwriteSplittingRuleStatementChecker.checkRuleNamesExist(segments, currentRuleConfig, databaseName);
        ReadwriteSplittingRuleStatementChecker.checkDataSourcesExist(databaseName, segments, database);
        ReadwriteSplittingRuleStatementChecker.checkDuplicatedDataSourceNames(databaseName, segments, currentRuleConfig, false);
        ReadwriteSplittingRuleStatementChecker.checkTransactionalReadQueryStrategy(segments);
        ReadwriteSplittingRuleStatementChecker.checkLoadBalancers(segments);
    }

    private static void checkRuleNamesExist(Collection<ReadwriteSplittingRuleSegment> segments, ReadwriteSplittingRuleConfiguration currentRuleConfig, String databaseName) {
        Collection requiredRuleNames = segments.stream().map(ReadwriteSplittingRuleSegment::getName).collect(Collectors.toList());
        Collection currentRuleNames = currentRuleConfig.getDataSourceGroups().stream().map(ReadwriteSplittingDataSourceGroupRuleConfiguration::getName).collect(Collectors.toList());
        Collection notExistedRuleNames = requiredRuleNames.stream().filter(each -> !currentRuleNames.contains(each)).collect(Collectors.toSet());
        ShardingSpherePreconditions.checkMustEmpty((Collection)notExistedRuleNames, () -> new MissingRequiredRuleException("Readwrite-splitting", databaseName, notExistedRuleNames));
    }

    private static void checkDuplicateRuleNames(ShardingSphereDatabase database, Collection<ReadwriteSplittingRuleSegment> segments, ReadwriteSplittingRuleConfiguration currentRuleConfig, boolean ifNotExists) {
        ReadwriteSplittingRuleStatementChecker.checkDuplicateRuleNamesWithSelf(database.getName(), segments);
        ReadwriteSplittingRuleStatementChecker.checkDuplicateRuleNamesWithExistsDataSources(database, segments);
        if (!ifNotExists) {
            ReadwriteSplittingRuleStatementChecker.checkDuplicateRuleNamesWithRuleConfiguration(database.getName(), currentRuleConfig, segments);
        }
    }

    private static void checkDuplicateRuleNamesWithSelf(String databaseName, Collection<ReadwriteSplittingRuleSegment> segments) {
        Collection<String> duplicatedRuleNames = ReadwriteSplittingRuleStatementChecker.getDuplicated(segments.stream().map(ReadwriteSplittingRuleSegment::getName).collect(Collectors.toList()));
        ShardingSpherePreconditions.checkMustEmpty(duplicatedRuleNames, () -> new DuplicateRuleException("Readwrite-splitting", databaseName, duplicatedRuleNames));
    }

    private static Collection<String> getDuplicated(Collection<String> required) {
        return required.stream().collect(Collectors.groupingBy(each -> each, Collectors.counting())).entrySet().stream().filter(each -> (Long)each.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private static void checkDuplicateRuleNamesWithExistsDataSources(ShardingSphereDatabase database, Collection<ReadwriteSplittingRuleSegment> segments) {
        HashSet<Object> currentRuleNames = new HashSet<Object>();
        ResourceMetaData resourceMetaData = database.getResourceMetaData();
        if (null != resourceMetaData && null != resourceMetaData.getStorageUnits()) {
            currentRuleNames.addAll(resourceMetaData.getStorageUnits().keySet());
        }
        currentRuleNames.addAll(ReadwriteSplittingRuleStatementChecker.getLogicDataSources(database));
        Collection toBeCreatedRuleNames = segments.stream().map(ReadwriteSplittingRuleSegment::getName).filter(currentRuleNames::contains).collect(Collectors.toList());
        ShardingSpherePreconditions.checkMustEmpty((Collection)toBeCreatedRuleNames, () -> new InvalidRuleConfigurationException("Readwrite-splitting", toBeCreatedRuleNames, Collections.singleton(String.format("%s already exists in storage unit", toBeCreatedRuleNames))));
    }

    private static void checkDuplicateRuleNamesWithRuleConfiguration(String databaseName, ReadwriteSplittingRuleConfiguration currentRuleConfig, Collection<ReadwriteSplittingRuleSegment> segments) {
        LinkedList currentRuleNames = new LinkedList();
        if (null != currentRuleConfig) {
            currentRuleNames.addAll(currentRuleConfig.getDataSourceGroups().stream().map(ReadwriteSplittingDataSourceGroupRuleConfiguration::getName).collect(Collectors.toList()));
        }
        Collection toBeCreatedRuleNames = segments.stream().map(ReadwriteSplittingRuleSegment::getName).filter(currentRuleNames::contains).collect(Collectors.toList());
        ShardingSpherePreconditions.checkMustEmpty((Collection)toBeCreatedRuleNames, () -> new DuplicateRuleException("Readwrite-splitting", databaseName, toBeCreatedRuleNames));
    }

    private static void checkDataSourcesExist(String databaseName, Collection<ReadwriteSplittingRuleSegment> segments, ShardingSphereDatabase database) {
        LinkedHashSet requiredDataSources = new LinkedHashSet();
        segments.forEach(each -> {
            requiredDataSources.add(each.getWriteDataSource());
            requiredDataSources.addAll(each.getReadDataSources());
        });
        Collection notExistedDataSources = database.getResourceMetaData().getNotExistedDataSources(requiredDataSources);
        ShardingSpherePreconditions.checkMustEmpty((Collection)notExistedDataSources, () -> new MissingRequiredStorageUnitsException(databaseName, notExistedDataSources));
    }

    private static Collection<String> getLogicDataSources(ShardingSphereDatabase database) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (DataSourceMapperRuleAttribute each : database.getRuleMetaData().getAttributes(DataSourceMapperRuleAttribute.class)) {
            result.addAll(each.getDataSourceMapper().keySet());
        }
        return result;
    }

    private static void checkDuplicatedDataSourceNames(String databaseName, Collection<ReadwriteSplittingRuleSegment> segments, ReadwriteSplittingRuleConfiguration currentRuleConfig, boolean isCreating) {
        HashSet<String> existedWriteDataSourceNames = new HashSet<String>();
        HashSet<String> existedReadDataSourceNames = new HashSet<String>();
        if (null != currentRuleConfig) {
            Collection<Object> toBeAlteredRuleNames = isCreating ? Collections.emptySet() : ReadwriteSplittingRuleStatementChecker.getToBeAlteredRuleNames(segments);
            for (ReadwriteSplittingDataSourceGroupRuleConfiguration each : currentRuleConfig.getDataSourceGroups()) {
                if (toBeAlteredRuleNames.contains(each.getName())) continue;
                existedWriteDataSourceNames.add(each.getWriteDataSourceName());
                existedReadDataSourceNames.addAll(each.getReadDataSourceNames());
            }
        }
        ReadwriteSplittingRuleStatementChecker.checkDuplicateWriteDataSourceNames(segments, databaseName, existedWriteDataSourceNames);
        ReadwriteSplittingRuleStatementChecker.checkDuplicateReadDataSourceNames(segments, databaseName, existedReadDataSourceNames);
    }

    private static Collection<String> getToBeAlteredRuleNames(Collection<ReadwriteSplittingRuleSegment> segments) {
        return segments.stream().map(ReadwriteSplittingRuleSegment::getName).collect(Collectors.toSet());
    }

    private static void checkDuplicateWriteDataSourceNames(Collection<ReadwriteSplittingRuleSegment> segments, String databaseName, Collection<String> writeDataSourceNames) {
        for (ReadwriteSplittingRuleSegment each : segments) {
            if (Strings.isNullOrEmpty((String)each.getWriteDataSource())) continue;
            String writeDataSource = each.getWriteDataSource();
            ShardingSpherePreconditions.checkState((boolean)writeDataSourceNames.add(writeDataSource), () -> new DuplicateReadwriteSplittingActualDataSourceException(ReadwriteSplittingDataSourceType.WRITE, writeDataSource, new ReadwriteSplittingRuleExceptionIdentifier(databaseName, "")));
        }
    }

    private static void checkDuplicateReadDataSourceNames(Collection<ReadwriteSplittingRuleSegment> segments, String databaseName, Collection<String> readDataSourceNames) {
        for (ReadwriteSplittingRuleSegment each : segments) {
            if (null == each.getReadDataSources()) continue;
            ReadwriteSplittingRuleStatementChecker.checkDuplicateReadDataSourceNames(each, databaseName, readDataSourceNames);
        }
    }

    private static void checkDuplicateReadDataSourceNames(ReadwriteSplittingRuleSegment segment, String databaseName, Collection<String> readDataSourceNames) {
        for (String each : segment.getReadDataSources()) {
            ShardingSpherePreconditions.checkState((boolean)readDataSourceNames.add(each), () -> new DuplicateReadwriteSplittingActualDataSourceException(ReadwriteSplittingDataSourceType.READ, each, new ReadwriteSplittingRuleExceptionIdentifier(databaseName, "")));
        }
    }

    private static void checkTransactionalReadQueryStrategy(Collection<ReadwriteSplittingRuleSegment> segments) {
        Collection validStrategyNames = Arrays.stream(TransactionalReadQueryStrategy.values()).map(Enum::name).collect(Collectors.toSet());
        for (ReadwriteSplittingRuleSegment each : segments) {
            if (null == each.getTransactionalReadQueryStrategy()) continue;
            ShardingSpherePreconditions.checkContains((Collection)validStrategyNames, (Object)each.getTransactionalReadQueryStrategy().toUpperCase(), () -> new MissingRequiredStrategyException("Transactional read query", Collections.singleton(each.getTransactionalReadQueryStrategy())));
        }
    }

    private static void checkLoadBalancers(Collection<ReadwriteSplittingRuleSegment> segments) {
        for (ReadwriteSplittingRuleSegment each : segments) {
            AlgorithmSegment loadBalancer = each.getLoadBalancer();
            if (null == loadBalancer) continue;
            TypedSPILoader.checkService(LoadBalanceAlgorithm.class, (Object)loadBalancer.getName(), (Properties)loadBalancer.getProps());
            ReadwriteSplittingRuleStatementChecker.checkProperties(each);
        }
    }

    private static void checkProperties(ReadwriteSplittingRuleSegment each) {
        if ("WEIGHT".equalsIgnoreCase(each.getLoadBalancer().getName())) {
            ShardingSpherePreconditions.checkNotEmpty((Map)each.getLoadBalancer().getProps(), () -> new InvalidAlgorithmConfigurationException("Load balancer", each.getLoadBalancer().getName()));
            ReadwriteSplittingRuleStatementChecker.checkDataSource(each);
        }
    }

    private static void checkDataSource(ReadwriteSplittingRuleSegment ruleSegment) {
        Set<String> weightKeys = ruleSegment.getLoadBalancer().getProps().stringPropertyNames();
        weightKeys.forEach(each -> ShardingSpherePreconditions.checkContains((Collection)ruleSegment.getReadDataSources(), (Object)each, () -> new InvalidAlgorithmConfigurationException("Load balancer", ruleSegment.getLoadBalancer().getName(), String.format("Can not find read storage unit '%s'", each))));
        ruleSegment.getReadDataSources().forEach(each -> ShardingSpherePreconditions.checkContains((Collection)weightKeys, (Object)each, () -> new InvalidAlgorithmConfigurationException("Load balancer", ruleSegment.getLoadBalancer().getName(), String.format("Weight of '%s' is required", each))));
    }

    @Generated
    private ReadwriteSplittingRuleStatementChecker() {
    }
}

