/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.distsql.handler.update;

import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorDatabaseAware;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorRuleAware;
import org.apache.shardingsphere.distsql.handler.engine.update.DistSQLUpdateExecutor;
import org.apache.shardingsphere.distsql.handler.required.DistSQLExecutorClusterModeRequired;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.resource.storageunit.InvalidStorageUnitStatusException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.MissingRequiredRuleException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.state.datasource.DataSourceState;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.readwritesplitting.constant.ReadwriteSplittingDataSourceType;
import org.apache.shardingsphere.readwritesplitting.distsql.statement.AlterReadwriteSplittingStorageUnitStatusStatement;
import org.apache.shardingsphere.readwritesplitting.exception.ReadwriteSplittingRuleExceptionIdentifier;
import org.apache.shardingsphere.readwritesplitting.exception.actual.ReadwriteSplittingActualDataSourceNotFoundException;
import org.apache.shardingsphere.readwritesplitting.rule.ReadwriteSplittingDataSourceGroupRule;
import org.apache.shardingsphere.readwritesplitting.rule.ReadwriteSplittingRule;

@DistSQLExecutorClusterModeRequired
public final class AlterReadwriteSplittingStorageUnitStatusExecutor
implements DistSQLUpdateExecutor<AlterReadwriteSplittingStorageUnitStatusStatement>,
DistSQLExecutorDatabaseAware,
DistSQLExecutorRuleAware<ReadwriteSplittingRule> {
    private ShardingSphereDatabase database;
    private ReadwriteSplittingRule rule;

    public void executeUpdate(AlterReadwriteSplittingStorageUnitStatusStatement sqlStatement, ContextManager contextManager) {
        this.checkBeforeUpdate(sqlStatement);
        this.updateStatus(contextManager, sqlStatement);
    }

    private void checkBeforeUpdate(AlterReadwriteSplittingStorageUnitStatusStatement sqlStatement) {
        ReadwriteSplittingDataSourceGroupRule dataSourceGroupRule = this.rule.getDataSourceRuleGroups().values().stream().filter(each -> each.getName().equalsIgnoreCase(sqlStatement.getRuleName())).findAny().orElseThrow(() -> new MissingRequiredRuleException("Readwrite-splitting", this.database.getName(), sqlStatement.getRuleName()));
        ShardingSpherePreconditions.checkContains((Collection)dataSourceGroupRule.getReadwriteSplittingGroup().getReadDataSources(), (Object)sqlStatement.getStorageUnitName(), () -> new ReadwriteSplittingActualDataSourceNotFoundException(ReadwriteSplittingDataSourceType.READ, sqlStatement.getStorageUnitName(), new ReadwriteSplittingRuleExceptionIdentifier(this.database.getName(), dataSourceGroupRule.getName())));
        if (sqlStatement.isEnable()) {
            ShardingSpherePreconditions.checkContains((Collection)dataSourceGroupRule.getDisabledDataSourceNames(), (Object)sqlStatement.getStorageUnitName(), () -> new InvalidStorageUnitStatusException("storage unit is not disabled"));
        } else {
            ShardingSpherePreconditions.checkNotContains((Collection)dataSourceGroupRule.getDisabledDataSourceNames(), (Object)sqlStatement.getStorageUnitName(), () -> new InvalidStorageUnitStatusException("storage unit is already disabled"));
        }
    }

    private void updateStatus(ContextManager contextManager, AlterReadwriteSplittingStorageUnitStatusStatement sqlStatement) {
        DataSourceState status = sqlStatement.isEnable() ? DataSourceState.ENABLED : DataSourceState.DISABLED;
        contextManager.getPersistServiceFacade().getQualifiedDataSourceStateService().update(this.database.getName(), sqlStatement.getRuleName(), sqlStatement.getStorageUnitName(), status);
    }

    public Class<ReadwriteSplittingRule> getRuleClass() {
        return ReadwriteSplittingRule.class;
    }

    public Class<AlterReadwriteSplittingStorageUnitStatusStatement> getType() {
        return AlterReadwriteSplittingStorageUnitStatusStatement.class;
    }

    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }

    @Generated
    public void setRule(ReadwriteSplittingRule rule) {
        this.rule = rule;
    }
}

