/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.firebird.command.query.blob.executors;

import java.util.Collection;
import java.util.Collections;
import java.util.OptionalLong;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.blob.FirebirdCancelBlobCommandPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.generic.FirebirdGenericResponsePacket;
import org.apache.shardingsphere.database.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.command.executor.CommandExecutor;
import org.apache.shardingsphere.proxy.frontend.firebird.command.query.blob.upload.FirebirdBlobUploadCache;
import org.apache.shardingsphere.proxy.frontend.firebird.command.query.statement.FirebirdStatementIdGenerator;

public final class FirebirdCancelBlobCommandExecutor
implements CommandExecutor {
    private final FirebirdCancelBlobCommandPacket packet;
    private final ConnectionSession connectionSession;

    public Collection<DatabasePacket> execute() {
        int blobHandle = this.packet.getBlobHandle();
        OptionalLong blobId = FirebirdBlobUploadCache.getInstance().getBlobId(this.connectionSession.getConnectionId(), blobHandle);
        if (blobId.isPresent()) {
            FirebirdBlobUploadCache.getInstance().removeUpload(this.connectionSession.getConnectionId(), blobId.getAsLong());
        }
        int statementId = FirebirdStatementIdGenerator.getInstance().nextStatementId(this.connectionSession.getConnectionId());
        return Collections.singleton(new FirebirdGenericResponsePacket().setHandle(statementId));
    }

    @Generated
    public FirebirdCancelBlobCommandExecutor(FirebirdCancelBlobCommandPacket packet, ConnectionSession connectionSession) {
        this.packet = packet;
        this.connectionSession = connectionSession;
    }
}

