/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.firebird.command.query.blob.metadata;

import java.util.OptionalInt;
import org.apache.shardingsphere.database.connector.firebird.metadata.data.FirebirdBlobInfoRegistry;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereColumn;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.proxy.frontend.firebird.command.query.blob.metadata.FirebirdBlobColumnMetaData;

public final class FirebirdBlobColumnMetaDataResolver {
    private final String databaseName;

    public FirebirdBlobColumnMetaDataResolver(String databaseName) {
        this.databaseName = databaseName;
    }

    public FirebirdBlobColumnMetaData resolve(ShardingSphereTable table, ShardingSphereColumn column) {
        boolean blobColumn = this.isBlobColumn(table, column);
        Integer blobSubtype = this.resolveBlobSubtype(table, column, blobColumn);
        return new FirebirdBlobColumnMetaData(blobColumn, blobSubtype);
    }

    private Integer resolveBlobSubtype(ShardingSphereTable table, ShardingSphereColumn column, boolean blobColumn) {
        if (!blobColumn) {
            return null;
        }
        OptionalInt subtype = FirebirdBlobInfoRegistry.findBlobSubtype((String)this.databaseName, (String)table.getName(), (String)column.getName());
        return subtype.isPresent() ? Integer.valueOf(subtype.getAsInt()) : null;
    }

    private boolean isBlobColumn(ShardingSphereTable table, ShardingSphereColumn column) {
        if (null == table || null == column) {
            return false;
        }
        if (FirebirdBlobInfoRegistry.isBlobColumn((String)this.databaseName, (String)table.getName(), (String)column.getName())) {
            return true;
        }
        return 2004 == column.getDataType();
    }
}

