/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.firebird.command.query.statement;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class FirebirdStatementIdGenerator {
    private static final FirebirdStatementIdGenerator INSTANCE = new FirebirdStatementIdGenerator();
    private final Map<Integer, AtomicInteger> connectionRegistry = new ConcurrentHashMap<Integer, AtomicInteger>();

    public static FirebirdStatementIdGenerator getInstance() {
        return INSTANCE;
    }

    public void registerConnection(int connectionId) {
        this.connectionRegistry.put(connectionId, new AtomicInteger());
    }

    public int nextStatementId(int connectionId) {
        return this.connectionRegistry.get(connectionId).incrementAndGet();
    }

    public int getStatementId(int connectionId) {
        return this.connectionRegistry.get(connectionId).get();
    }

    public void unregisterConnection(int connectionId) {
        this.connectionRegistry.remove(connectionId);
    }
}

