/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.distsql.handler.converter;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.distsql.handler.engine.query.ral.convert.AlgorithmDistSQLConverter;
import org.apache.shardingsphere.distsql.handler.engine.query.ral.convert.RuleConfigurationToDistSQLConverter;
import org.apache.shardingsphere.encrypt.config.EncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.config.rule.EncryptColumnItemRuleConfiguration;
import org.apache.shardingsphere.encrypt.config.rule.EncryptColumnRuleConfiguration;
import org.apache.shardingsphere.encrypt.config.rule.EncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.distsql.handler.converter.EncryptConvertDistSQLConstants;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;

public final class EncryptRuleConfigurationToDistSQLConverter
implements RuleConfigurationToDistSQLConverter<EncryptRuleConfiguration> {
    public String convert(EncryptRuleConfiguration ruleConfig) {
        return ruleConfig.getTables().isEmpty() ? "" : "CREATE ENCRYPT RULE" + this.convertEncryptTables(ruleConfig) + ";";
    }

    private String convertEncryptTables(EncryptRuleConfiguration ruleConfig) {
        return ruleConfig.getTables().stream().map(each -> this.convertEncryptTable(ruleConfig, (EncryptTableRuleConfiguration)each)).collect(Collectors.joining("," + System.lineSeparator()));
    }

    private String convertEncryptTable(EncryptRuleConfiguration ruleConfig, EncryptTableRuleConfiguration tableRuleConfig) {
        return String.format(EncryptConvertDistSQLConstants.ENCRYPT_TABLE, tableRuleConfig.getName(), this.convertEncryptColumns(tableRuleConfig.getColumns(), ruleConfig.getEncryptors()));
    }

    private String convertEncryptColumns(Collection<EncryptColumnRuleConfiguration> columnRuleConfigs, Map<String, AlgorithmConfiguration> encryptors) {
        return columnRuleConfigs.stream().map(each -> this.convertEncryptColumn((EncryptColumnRuleConfiguration)each, encryptors)).collect(Collectors.joining("," + System.lineSeparator()));
    }

    private String convertEncryptColumn(EncryptColumnRuleConfiguration columnRuleConfig, Map<String, AlgorithmConfiguration> encryptors) {
        return String.format("(NAME=%s, %s, %s)", columnRuleConfig.getName(), this.convertColumns(columnRuleConfig), this.convertEncryptAlgorithms(columnRuleConfig, encryptors));
    }

    private String convertColumns(EncryptColumnRuleConfiguration columnRuleConfig) {
        StringBuilder result = new StringBuilder();
        result.append(String.format("CIPHER=%s", columnRuleConfig.getCipher().getName()));
        columnRuleConfig.getAssistedQuery().ifPresent(optional -> result.append(",").append(' ').append(String.format("ASSISTED_QUERY_COLUMN=%s", optional.getName())));
        columnRuleConfig.getLikeQuery().ifPresent(optional -> result.append(",").append(' ').append(String.format("LIKE_QUERY_COLUMN=%s", optional.getName())));
        return result.toString();
    }

    private String convertEncryptAlgorithms(EncryptColumnRuleConfiguration columnRuleConfig, Map<String, AlgorithmConfiguration> encryptors) {
        StringBuilder result = new StringBuilder();
        result.append(String.format("ENCRYPT_ALGORITHM(%s)", AlgorithmDistSQLConverter.getAlgorithmType((AlgorithmConfiguration)encryptors.get(columnRuleConfig.getCipher().getEncryptorName()))));
        columnRuleConfig.getAssistedQuery().map(EncryptColumnItemRuleConfiguration::getEncryptorName).ifPresent(optional -> result.append(",").append(' ').append(String.format("ASSISTED_QUERY_ALGORITHM(%s)", AlgorithmDistSQLConverter.getAlgorithmType((AlgorithmConfiguration)((AlgorithmConfiguration)encryptors.get(optional))))));
        columnRuleConfig.getLikeQuery().map(EncryptColumnItemRuleConfiguration::getEncryptorName).ifPresent(optional -> result.append(",").append(' ').append(String.format("LIKE_QUERY_ALGORITHM(%s)", AlgorithmDistSQLConverter.getAlgorithmType((AlgorithmConfiguration)((AlgorithmConfiguration)encryptors.get(optional))))));
        return result.toString();
    }

    public Class<EncryptRuleConfiguration> getType() {
        return EncryptRuleConfiguration.class;
    }
}

