/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.distsql.handler.update;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.type.DatabaseRuleCreateExecutor;
import org.apache.shardingsphere.distsql.segment.AlgorithmSegment;
import org.apache.shardingsphere.encrypt.config.EncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.distsql.handler.converter.EncryptRuleStatementConverter;
import org.apache.shardingsphere.encrypt.distsql.segment.EncryptColumnItemSegment;
import org.apache.shardingsphere.encrypt.distsql.segment.EncryptColumnSegment;
import org.apache.shardingsphere.encrypt.distsql.segment.EncryptRuleSegment;
import org.apache.shardingsphere.encrypt.distsql.statement.CreateEncryptRuleStatement;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;
import org.apache.shardingsphere.infra.algorithm.core.ShardingSphereAlgorithm;
import org.apache.shardingsphere.infra.algorithm.core.exception.AlgorithmInitializationException;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.resource.storageunit.EmptyStorageUnitException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.DuplicateRuleException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.InvalidRuleConfigurationException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;

public final class CreateEncryptRuleExecutor
implements DatabaseRuleCreateExecutor<CreateEncryptRuleStatement, EncryptRule, EncryptRuleConfiguration> {
    private ShardingSphereDatabase database;
    private EncryptRule rule;

    public void checkBeforeUpdate(CreateEncryptRuleStatement sqlStatement) {
        if (!sqlStatement.isIfNotExists()) {
            this.checkDuplicateRuleNames(sqlStatement);
        }
        this.checkColumnNames(sqlStatement);
        this.checkAlgorithmTypes(sqlStatement);
        this.checkToBeCreatedEncryptors(sqlStatement);
        this.checkDataSources();
    }

    private void checkDuplicateRuleNames(CreateEncryptRuleStatement sqlStatement) {
        Collection<String> duplicatedRuleNames = this.getDuplicatedRuleNames(sqlStatement);
        ShardingSpherePreconditions.checkMustEmpty(duplicatedRuleNames, () -> new DuplicateRuleException("encrypt", this.database.getName(), duplicatedRuleNames));
    }

    private Collection<String> getDuplicatedRuleNames(CreateEncryptRuleStatement sqlStatement) {
        return null == this.rule ? Collections.emptyList() : (Collection)sqlStatement.getRules().stream().map(EncryptRuleSegment::getTableName).filter(this.rule.getAllTableNames()::contains).collect(Collectors.toSet());
    }

    private void checkColumnNames(CreateEncryptRuleStatement sqlStatement) {
        for (EncryptRuleSegment each : sqlStatement.getRules()) {
            ShardingSpherePreconditions.checkState((boolean)this.isColumnNameNotConflicts(each), () -> new InvalidRuleConfigurationException("encrypt", "assisted query column or like query column conflicts with logic column"));
        }
    }

    private boolean isColumnNameNotConflicts(EncryptRuleSegment rule) {
        return rule.getColumns().stream().noneMatch(each -> null != each.getLikeQuery() && each.getName().equals(each.getLikeQuery().getName()) || null != each.getAssistedQuery() && each.getName().equals(each.getAssistedQuery().getName()));
    }

    private void checkAlgorithmTypes(CreateEncryptRuleStatement sqlStatement) {
        sqlStatement.getRules().stream().flatMap(each -> each.getColumns().stream()).forEach(each -> {
            this.checkStandardAlgorithmType(each.getCipher());
            this.checkLikeAlgorithmType(each.getLikeQuery());
            this.checkAssistedAlgorithmType(each.getAssistedQuery());
        });
    }

    private void checkStandardAlgorithmType(EncryptColumnItemSegment itemSegment) {
        if (null == itemSegment || null == itemSegment.getEncryptor()) {
            return;
        }
        EncryptAlgorithm encryptAlgorithm = (EncryptAlgorithm)TypedSPILoader.getService(EncryptAlgorithm.class, (Object)itemSegment.getEncryptor().getName(), (Properties)itemSegment.getEncryptor().getProps());
        ShardingSpherePreconditions.checkState((boolean)encryptAlgorithm.getMetaData().isSupportDecrypt(), () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)encryptAlgorithm, "Can not support decrypt", new Object[0]));
    }

    private void checkLikeAlgorithmType(EncryptColumnItemSegment itemSegment) {
        if (null == itemSegment || null == itemSegment.getEncryptor()) {
            return;
        }
        EncryptAlgorithm encryptAlgorithm = (EncryptAlgorithm)TypedSPILoader.getService(EncryptAlgorithm.class, (Object)itemSegment.getEncryptor().getName(), (Properties)itemSegment.getEncryptor().getProps());
        ShardingSpherePreconditions.checkState((boolean)encryptAlgorithm.getMetaData().isSupportLike(), () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)encryptAlgorithm, "Can not support like", new Object[0]));
    }

    private void checkAssistedAlgorithmType(EncryptColumnItemSegment itemSegment) {
        if (null == itemSegment || null == itemSegment.getEncryptor()) {
            return;
        }
        EncryptAlgorithm encryptAlgorithm = (EncryptAlgorithm)TypedSPILoader.getService(EncryptAlgorithm.class, (Object)itemSegment.getEncryptor().getName(), (Properties)itemSegment.getEncryptor().getProps());
        ShardingSpherePreconditions.checkState((boolean)encryptAlgorithm.getMetaData().isSupportEquivalentFilter(), () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)encryptAlgorithm, "Can not support assist query", new Object[0]));
    }

    private void checkToBeCreatedEncryptors(CreateEncryptRuleStatement sqlStatement) {
        LinkedHashSet encryptors = new LinkedHashSet();
        sqlStatement.getRules().forEach(each -> each.getColumns().forEach(column -> this.addToEncryptors((EncryptColumnSegment)column, encryptors)));
        encryptors.stream().filter(Objects::nonNull).forEach(each -> TypedSPILoader.checkService(EncryptAlgorithm.class, (Object)each.getName(), (Properties)each.getProps()));
    }

    private void addToEncryptors(EncryptColumnSegment column, Collection<AlgorithmSegment> result) {
        result.add(column.getCipher().getEncryptor());
        if (null != column.getAssistedQuery()) {
            result.add(column.getAssistedQuery().getEncryptor());
        }
        if (null != column.getLikeQuery()) {
            result.add(column.getLikeQuery().getEncryptor());
        }
    }

    private void checkDataSources() {
        ShardingSpherePreconditions.checkNotEmpty((Map)this.database.getResourceMetaData().getStorageUnits(), () -> new EmptyStorageUnitException(this.database.getName()));
    }

    public EncryptRuleConfiguration buildToBeCreatedRuleConfiguration(CreateEncryptRuleStatement sqlStatement) {
        Collection segments = sqlStatement.getRules();
        if (sqlStatement.isIfNotExists()) {
            Collection<String> duplicatedRuleNames = this.getDuplicatedRuleNames(sqlStatement);
            segments.removeIf(each -> duplicatedRuleNames.contains(each.getTableName()));
        }
        return EncryptRuleStatementConverter.convert(segments);
    }

    public Class<EncryptRule> getRuleClass() {
        return EncryptRule.class;
    }

    public Class<CreateEncryptRuleStatement> getType() {
        return CreateEncryptRuleStatement.class;
    }

    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }

    @Generated
    public void setRule(EncryptRule rule) {
        this.rule = rule;
    }
}

