/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.broadcast.distsql.handler.update;

import com.cedarsoftware.util.CaseInsensitiveSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.broadcast.config.BroadcastRuleConfiguration;
import org.apache.shardingsphere.broadcast.distsql.statement.DropBroadcastTableRuleStatement;
import org.apache.shardingsphere.broadcast.rule.BroadcastRule;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.type.DatabaseRuleDropExecutor;
import org.apache.shardingsphere.distsql.handler.required.DistSQLExecutorCurrentRuleRequired;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.MissingRequiredRuleException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;

@DistSQLExecutorCurrentRuleRequired(value=BroadcastRule.class)
public final class DropBroadcastTableRuleExecutor
implements DatabaseRuleDropExecutor<DropBroadcastTableRuleStatement, BroadcastRule, BroadcastRuleConfiguration> {
    private ShardingSphereDatabase database;
    private BroadcastRule rule;

    public void checkBeforeUpdate(DropBroadcastTableRuleStatement sqlStatement) {
        if (!sqlStatement.isIfExists()) {
            this.checkBroadcastTableExist(sqlStatement);
        }
    }

    private void checkBroadcastTableExist(DropBroadcastTableRuleStatement sqlStatement) {
        CaseInsensitiveSet currentTableNames = new CaseInsensitiveSet(this.rule.getConfiguration().getTables());
        Collection notExistedTableNames = sqlStatement.getTables().stream().filter(arg_0 -> DropBroadcastTableRuleExecutor.lambda$checkBroadcastTableExist$0((Collection)currentTableNames, arg_0)).collect(Collectors.toList());
        ShardingSpherePreconditions.checkMustEmpty((Collection)notExistedTableNames, () -> new MissingRequiredRuleException("Broadcast", this.database.getName(), notExistedTableNames));
    }

    public boolean hasAnyOneToBeDropped(DropBroadcastTableRuleStatement sqlStatement) {
        return !Collections.disjoint(this.rule.getConfiguration().getTables(), sqlStatement.getTables());
    }

    public BroadcastRuleConfiguration buildToBeAlteredRuleConfiguration(DropBroadcastTableRuleStatement sqlStatement) {
        BroadcastRuleConfiguration result = new BroadcastRuleConfiguration(new HashSet(this.rule.getConfiguration().getTables()));
        CaseInsensitiveSet toBeDroppedTableNames = new CaseInsensitiveSet(sqlStatement.getTables());
        result.getTables().removeIf(((Collection)toBeDroppedTableNames)::contains);
        return result;
    }

    public Class<BroadcastRule> getRuleClass() {
        return BroadcastRule.class;
    }

    public Class<DropBroadcastTableRuleStatement> getType() {
        return DropBroadcastTableRuleStatement.class;
    }

    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }

    @Generated
    public void setRule(BroadcastRule rule) {
        this.rule = rule;
    }

    private static /* synthetic */ boolean lambda$checkBroadcastTableExist$0(Collection currentTableNames, String each) {
        return !currentTableNames.contains(each);
    }
}

