/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.rule;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.scope.GlobalRule;
import org.apache.shardingsphere.sqlfederation.compiler.context.CompilerContext;
import org.apache.shardingsphere.sqlfederation.compiler.context.CompilerContextFactory;
import org.apache.shardingsphere.sqlfederation.compiler.exception.InvalidExecutionPlanCacheConfigException;
import org.apache.shardingsphere.sqlfederation.config.SQLFederationCacheOption;
import org.apache.shardingsphere.sqlfederation.config.SQLFederationRuleConfiguration;

public final class SQLFederationRule
implements GlobalRule {
    private final SQLFederationRuleConfiguration configuration;
    private final AtomicReference<CompilerContext> compilerContext;

    public SQLFederationRule(SQLFederationRuleConfiguration ruleConfig, Collection<ShardingSphereDatabase> databases) {
        this.configuration = ruleConfig;
        this.compilerContext = new AtomicReference<CompilerContext>(CompilerContextFactory.create(databases));
        this.checkExecutionPlanCacheConfiguration(ruleConfig.getExecutionPlanCache());
    }

    private void checkExecutionPlanCacheConfiguration(SQLFederationCacheOption executionPlanCache) {
        ShardingSpherePreconditions.checkState((executionPlanCache.getInitialCapacity() > 0 ? 1 : 0) != 0, () -> new InvalidExecutionPlanCacheConfigException((Object)"initialCapacity", (Object)executionPlanCache.getInitialCapacity()));
        ShardingSpherePreconditions.checkState((executionPlanCache.getMaximumSize() > 0L ? 1 : 0) != 0, () -> new InvalidExecutionPlanCacheConfigException((Object)"maximumSize", (Object)executionPlanCache.getMaximumSize()));
    }

    public CompilerContext getCompilerContext() {
        return this.compilerContext.get();
    }

    public void refresh(Collection<ShardingSphereDatabase> databases, GlobalRule.GlobalRuleChangedType changedType) {
        this.compilerContext.set(CompilerContextFactory.create(databases));
    }

    public int getOrder() {
        return 1000;
    }

    @Generated
    public SQLFederationRuleConfiguration getConfiguration() {
        return this.configuration;
    }
}

