/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.distsql.handler.update;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.type.DatabaseRuleDropExecutor;
import org.apache.shardingsphere.distsql.handler.required.DistSQLExecutorCurrentRuleRequired;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.algorithm.core.exception.InUsedAlgorithmException;
import org.apache.shardingsphere.infra.algorithm.core.exception.UnregisteredAlgorithmException;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.external.sql.identifier.SQLExceptionIdentifier;
import org.apache.shardingsphere.infra.exception.external.sql.type.kernel.KernelSQLException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.shadow.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.config.table.ShadowTableConfiguration;
import org.apache.shardingsphere.shadow.distsql.handler.checker.ShadowRuleStatementChecker;
import org.apache.shardingsphere.shadow.distsql.handler.supporter.ShadowRuleStatementSupporter;
import org.apache.shardingsphere.shadow.distsql.statement.DropShadowAlgorithmStatement;
import org.apache.shardingsphere.shadow.rule.ShadowRule;

@DistSQLExecutorCurrentRuleRequired(value=ShadowRule.class)
public final class DropShadowAlgorithmExecutor
implements DatabaseRuleDropExecutor<DropShadowAlgorithmStatement, ShadowRule, ShadowRuleConfiguration> {
    private ShardingSphereDatabase database;
    private ShadowRule rule;

    public void checkBeforeUpdate(DropShadowAlgorithmStatement sqlStatement) {
        if (!sqlStatement.isIfExists()) {
            this.checkAlgorithm(sqlStatement);
        }
    }

    private void checkAlgorithm(DropShadowAlgorithmStatement sqlStatement) {
        List<String> currentAlgorithms = ShadowRuleStatementSupporter.getAlgorithmNames(this.rule.getConfiguration());
        Collection requiredAlgorithms = sqlStatement.getNames();
        String defaultShadowAlgorithmName = this.rule.getConfiguration().getDefaultShadowAlgorithmName();
        if (!sqlStatement.isIfExists()) {
            ShadowRuleStatementChecker.checkExisted(requiredAlgorithms, currentAlgorithms, notExistedAlgorithms -> new UnregisteredAlgorithmException("Shadow", notExistedAlgorithms, new SQLExceptionIdentifier(this.database.getName())));
        }
        this.checkAlgorithmInUsed(requiredAlgorithms, this.getAlgorithmInUse(), identical -> new InUsedAlgorithmException("Shadow", this.database.getName(), identical));
        ShardingSpherePreconditions.checkNotContains((Collection)requiredAlgorithms, (Object)defaultShadowAlgorithmName, () -> new InUsedAlgorithmException("Shadow", this.database.getName(), Collections.singleton(defaultShadowAlgorithmName)));
    }

    private void checkAlgorithmInUsed(Collection<String> requiredAlgorithms, Collection<String> currentAlgorithms, Function<Collection<String>, KernelSQLException> thrower) {
        ShadowRuleStatementChecker.checkDuplicated(requiredAlgorithms, currentAlgorithms, thrower);
    }

    private Collection<String> getAlgorithmInUse() {
        return this.rule.getConfiguration().getTables().values().stream().filter(each -> !each.getDataSourceNames().isEmpty()).map(ShadowTableConfiguration::getShadowAlgorithmNames).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public boolean hasAnyOneToBeDropped(DropShadowAlgorithmStatement sqlStatement) {
        return !Collections.disjoint(ShadowRuleStatementSupporter.getAlgorithmNames(this.rule.getConfiguration()), sqlStatement.getNames());
    }

    public ShadowRuleConfiguration buildToBeDroppedRuleConfiguration(DropShadowAlgorithmStatement sqlStatement) {
        ShadowRuleConfiguration result = new ShadowRuleConfiguration();
        for (String each : sqlStatement.getNames()) {
            result.getShadowAlgorithms().put(each, (AlgorithmConfiguration)this.rule.getConfiguration().getShadowAlgorithms().get(each));
        }
        return result;
    }

    public Class<ShadowRule> getRuleClass() {
        return ShadowRule.class;
    }

    public Class<DropShadowAlgorithmStatement> getType() {
        return DropShadowAlgorithmStatement.class;
    }

    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }

    @Generated
    public void setRule(ShadowRule rule) {
        this.rule = rule;
    }
}

