/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.migration.distsql.handler.update;

import java.util.ArrayList;
import java.util.Map;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContextKey;
import org.apache.shardingsphere.data.pipeline.core.job.api.TransmissionJobAPI;
import org.apache.shardingsphere.data.pipeline.scenario.migration.api.MigrationJobAPI;
import org.apache.shardingsphere.data.pipeline.scenario.migration.distsql.statement.updatable.RegisterMigrationSourceStorageUnitStatement;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeFactory;
import org.apache.shardingsphere.distsql.handler.engine.update.DistSQLUpdateExecutor;
import org.apache.shardingsphere.distsql.handler.required.DistSQLExecutorClusterModeRequired;
import org.apache.shardingsphere.distsql.handler.validate.DistSQLDataSourcePoolPropertiesValidator;
import org.apache.shardingsphere.distsql.segment.HostnameAndPortBasedDataSourceSegment;
import org.apache.shardingsphere.distsql.segment.URLBasedDataSourceSegment;
import org.apache.shardingsphere.distsql.segment.converter.DataSourceSegmentsConverter;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.infra.instance.metadata.InstanceType;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.mode.manager.ContextManager;

@DistSQLExecutorClusterModeRequired
public final class RegisterMigrationSourceStorageUnitExecutor
implements DistSQLUpdateExecutor<RegisterMigrationSourceStorageUnitStatement> {
    private final MigrationJobAPI jobAPI = (MigrationJobAPI)TypedSPILoader.getService(TransmissionJobAPI.class, (Object)"MIGRATION");
    private final DistSQLDataSourcePoolPropertiesValidator validateHandler = new DistSQLDataSourcePoolPropertiesValidator();

    public void executeUpdate(RegisterMigrationSourceStorageUnitStatement sqlStatement, ContextManager contextManager) {
        this.checkDataSource(sqlStatement);
        ArrayList dataSources = new ArrayList(sqlStatement.getDataSources());
        URLBasedDataSourceSegment urlBasedDataSourceSegment = (URLBasedDataSourceSegment)dataSources.get(0);
        DatabaseType databaseType = DatabaseTypeFactory.get((String)urlBasedDataSourceSegment.getUrl());
        Map propsMap = DataSourceSegmentsConverter.convert((DatabaseType)databaseType, dataSources);
        this.validateHandler.validate(propsMap);
        this.jobAPI.registerMigrationSourceStorageUnits(new PipelineContextKey(InstanceType.PROXY), propsMap);
    }

    private void checkDataSource(RegisterMigrationSourceStorageUnitStatement sqlStatement) {
        ShardingSpherePreconditions.checkState((boolean)sqlStatement.getDataSources().stream().noneMatch(HostnameAndPortBasedDataSourceSegment.class::isInstance), () -> new UnsupportedSQLOperationException("Not currently support add hostname and port, please use url"));
    }

    public Class<RegisterMigrationSourceStorageUnitStatement> getType() {
        return RegisterMigrationSourceStorageUnitStatement.class;
    }
}

