/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.select;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.shardingsphere.authority.checker.AuthorityChecker;
import org.apache.shardingsphere.authority.rule.AuthorityRule;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.ResourceMetaData;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseMetaDataExecutor;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class SelectInformationSchemataExecutor
extends DatabaseMetaDataExecutor {
    public static final String SCHEMA_NAME = "SCHEMA_NAME";
    public static final String DEFAULT_CHARACTER_SET_NAME = "DEFAULT_CHARACTER_SET_NAME";
    public static final String DEFAULT_COLLATION_NAME = "DEFAULT_COLLATION_NAME";
    public static final String CATALOG_NAME = "CATALOG_NAME";
    public static final String SQL_PATH = "SQL_PATH";
    public static final String DEFAULT_ENCRYPTION = "DEFAULT_ENCRYPTION";
    private static final Collection<String> EMPTY_DATABASES = new LinkedHashSet<String>();
    private final SelectStatement sqlStatement;
    private String schemaNameAlias = "SCHEMA_NAME";
    private boolean queryDatabase;

    public SelectInformationSchemataExecutor(SelectStatement sqlStatement, String sql, List<Object> parameters) {
        super(sql, parameters);
        this.sqlStatement = sqlStatement;
    }

    protected Collection<ShardingSphereDatabase> getDatabases(ConnectionSession connectionSession, ShardingSphereMetaData metaData) {
        AuthorityChecker authorityChecker = new AuthorityChecker((AuthorityRule)metaData.getGlobalRuleMetaData().getSingleRule(AuthorityRule.class), connectionSession.getConnectionContext().getGrantee());
        Collection databases = metaData.getAllDatabases().stream().filter(each -> authorityChecker.isAuthorized(each.getName())).collect(Collectors.toList());
        EMPTY_DATABASES.addAll(databases.stream().filter(each -> !each.containsDataSource()).map(ShardingSphereDatabase::getName).collect(Collectors.toSet()));
        Collection result = databases.stream().filter(ShardingSphereDatabase::containsDataSource).collect(Collectors.toList());
        if (!EMPTY_DATABASES.isEmpty()) {
            this.fillDatabasesWithoutDataSource(this.getDefaultRowData());
        }
        return result;
    }

    private void fillDatabasesWithoutDataSource(Map<String, String> defaultRowData) {
        for (String each : EMPTY_DATABASES) {
            LinkedHashMap<String, String> row = new LinkedHashMap<String, String>(defaultRowData);
            row.replace(this.schemaNameAlias, each);
            this.getRows().add(row);
        }
        EMPTY_DATABASES.clear();
    }

    private Map<String, String> getDefaultRowData() {
        List projections = this.sqlStatement.getProjections().getProjections();
        return projections.stream().anyMatch(ShorthandProjectionSegment.class::isInstance) ? this.getDefaultRowsFromShorthandProjection() : this.getDefaultRowsFromColumnProjections(this.filterColumnProjections(projections));
    }

    private Map<String, String> getDefaultRowsFromShorthandProjection() {
        return Stream.of(CATALOG_NAME, SCHEMA_NAME, DEFAULT_CHARACTER_SET_NAME, DEFAULT_COLLATION_NAME, SQL_PATH, DEFAULT_ENCRYPTION).collect(Collectors.toMap(each -> each, each -> "", (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    private List<ColumnProjectionSegment> filterColumnProjections(Collection<ProjectionSegment> projections) {
        return projections.stream().filter(each -> each.getClass().isAssignableFrom(ColumnProjectionSegment.class)).map(ColumnProjectionSegment.class::cast).collect(Collectors.toList());
    }

    private Map<String, String> getDefaultRowsFromColumnProjections(Collection<ColumnProjectionSegment> projections) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(projections.size(), 1.0f);
        for (ColumnProjectionSegment each : projections) {
            if (each.getAlias().isPresent()) {
                String alias = ((IdentifierValue)each.getAlias().get()).getValue();
                if (each.getColumn().getIdentifier().getValue().equalsIgnoreCase(SCHEMA_NAME)) {
                    this.schemaNameAlias = alias;
                }
                result.put(alias, "");
                continue;
            }
            result.put(each.getColumn().getIdentifier().getValue().toUpperCase(), "");
        }
        return result;
    }

    protected void preProcess(ShardingSphereDatabase database, Map<String, Object> rows, Map<String, String> alias) throws SQLException {
        Optional<String> catalog = this.findCatalog(database.getResourceMetaData());
        this.schemaNameAlias = alias.getOrDefault(SCHEMA_NAME, alias.getOrDefault(this.schemaNameAlias, this.schemaNameAlias));
        String rowValue = rows.getOrDefault(this.schemaNameAlias, "").toString();
        boolean bl = this.queryDatabase = !rowValue.isEmpty();
        if (catalog.isPresent() && rowValue.equals(catalog.get())) {
            rows.replace(this.schemaNameAlias, database.getName());
        } else {
            rows.clear();
        }
    }

    private Optional<String> findCatalog(ResourceMetaData resourceMetaData) throws SQLException {
        Optional storageUnit = resourceMetaData.getStorageUnits().values().stream().findFirst();
        if (!storageUnit.isPresent()) {
            return Optional.empty();
        }
        try (Connection connection = ((StorageUnit)storageUnit.get()).getDataSource().getConnection();){
            Optional<String> optional = Optional.of(connection.getCatalog());
            return optional;
        }
    }

    protected void postProcess() {
        this.removeDuplicatedRow();
    }

    private void removeDuplicatedRow() {
        if (this.queryDatabase) {
            Collection reservedRow = this.getRows().stream().collect(Collectors.groupingBy(each -> Optional.ofNullable(each.get(this.schemaNameAlias)), Collectors.toCollection(LinkedList::new))).values().stream().map(LinkedList::getFirst).collect(Collectors.toList());
            reservedRow.forEach(each -> this.getRows().removeIf(row -> !this.getRows().contains(each)));
        }
    }
}

