/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.constant;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public enum FirebirdUserDataType {
    CNCT_USER(1),
    CNCT_PASSWD(2),
    CNCT_HOST(4),
    CNCT_GROUP(5),
    CNCT_USER_VERIFICATION(6),
    CNCT_SPECIFIC_DATA(7),
    CNCT_PLUGIN_NAME(8),
    CNCT_LOGIN(9),
    CNCT_PLUGIN_LIST(10),
    CNCT_CLIENT_CRYPT(11);

    private static final Map<Integer, FirebirdUserDataType> FIREBIRD_USER_DATA_TYPE_CACHE;
    private final int code;

    public static FirebirdUserDataType valueOf(int code) {
        FirebirdUserDataType result = FIREBIRD_USER_DATA_TYPE_CACHE.get(code);
        Preconditions.checkNotNull((Object)((Object)result), (String)"Cannot find '%d' in user data type", (int)code);
        return result;
    }

    @Generated
    private FirebirdUserDataType(int code) {
        this.code = code;
    }

    @Generated
    public int getCode() {
        return this.code;
    }

    static {
        FIREBIRD_USER_DATA_TYPE_CACHE = new HashMap<Integer, FirebirdUserDataType>();
        for (FirebirdUserDataType each : FirebirdUserDataType.values()) {
            FIREBIRD_USER_DATA_TYPE_CACHE.put(each.code, each);
        }
    }
}

