/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.packet.command.query.info.type.sql;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.info.FirebirdInfoPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.info.FirebirdInfoPacketType;
import org.apache.shardingsphere.database.protocol.firebird.payload.FirebirdPacketPayload;

public enum FirebirdSQLInfoPacketType implements FirebirdInfoPacketType
{
    SELECT(4),
    BIND(5),
    NUM_VARIABLES(6),
    DESCRIBE_VARS(7),
    DESCRIBE_END(8),
    SQLDA_SEQ(9),
    MESSAGE_SEQ(10),
    TYPE(11),
    SUB_TYPE(12),
    SCALE(13),
    LENGTH(14),
    NULL_IND(15),
    FIELD(16),
    RELATION(17),
    OWNER(18),
    ALIAS(19),
    SQLDA_START(20),
    STMT_TYPE(21),
    GET_PLAN(22),
    RECORDS(23),
    BATCH_FETCH(24),
    RELATION_ALIAS(25),
    EXPLAIN_PLAN(26),
    STMT_FLAGS(27),
    STMT_TIMEOUT_USER(28),
    STMT_TIMEOUT_RUN(29),
    STMT_BLOB_ALIGN(30);

    private static final Map<Integer, FirebirdSQLInfoPacketType> FIREBIRD_DATABASE_INFO_TYPE_CACHE;
    private final int code;

    public static FirebirdSQLInfoPacketType valueOf(int code) {
        return FIREBIRD_DATABASE_INFO_TYPE_CACHE.get(code);
    }

    public static FirebirdInfoPacket createPacket(FirebirdPacketPayload payload) {
        return new FirebirdInfoPacket(payload, FirebirdSQLInfoPacketType::valueOf);
    }

    @Override
    public boolean isCommon() {
        return false;
    }

    @Generated
    private FirebirdSQLInfoPacketType(int code) {
        this.code = code;
    }

    @Override
    @Generated
    public int getCode() {
        return this.code;
    }

    static {
        FIREBIRD_DATABASE_INFO_TYPE_CACHE = new HashMap<Integer, FirebirdSQLInfoPacketType>();
        for (FirebirdSQLInfoPacketType each : FirebirdSQLInfoPacketType.values()) {
            FIREBIRD_DATABASE_INFO_TYPE_CACHE.put(each.code, each);
        }
    }
}

