/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.packet.generic;

import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.firebird.err.FirebirdStatusVector;
import org.apache.shardingsphere.database.protocol.firebird.packet.FirebirdPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.FirebirdCommandPacketType;
import org.apache.shardingsphere.database.protocol.firebird.payload.FirebirdPacketPayload;
import org.apache.shardingsphere.database.protocol.payload.PacketPayload;

public final class FirebirdGenericResponsePacket
extends FirebirdPacket {
    private int handle;
    private long id;
    private FirebirdPacket data;
    private FirebirdStatusVector statusVector;
    private boolean writeZeroStatementId;

    public static FirebirdGenericResponsePacket getPacket() {
        return new FirebirdGenericResponsePacket();
    }

    public FirebirdGenericResponsePacket setHandle(int objectHandle) {
        this.handle = objectHandle;
        return this;
    }

    public FirebirdGenericResponsePacket setId(int objectId) {
        this.id = objectId;
        return this;
    }

    public FirebirdGenericResponsePacket setId(long objectId) {
        this.id = objectId;
        return this;
    }

    public FirebirdGenericResponsePacket setData(FirebirdPacket packet) {
        this.data = packet;
        return this;
    }

    public FirebirdGenericResponsePacket setErrorStatusVector(SQLException ex) {
        this.statusVector = new FirebirdStatusVector(ex);
        return this;
    }

    public int getErrorCode() {
        return this.statusVector == null ? -1 : this.statusVector.getGdsCode();
    }

    public String getErrorMessage() {
        return this.statusVector == null ? "" : this.statusVector.getErrorMessage();
    }

    public FirebirdGenericResponsePacket setWriteZeroStatementId(boolean writeZeroStatementId) {
        this.writeZeroStatementId = writeZeroStatementId;
        return this;
    }

    @Override
    protected void write(FirebirdPacketPayload payload) {
        payload.writeInt4(FirebirdCommandPacketType.RESPONSE.getValue());
        payload.writeInt4(this.writeZeroStatementId ? 0 : this.handle);
        this.writeZeroStatementId = false;
        payload.writeInt8(this.id);
        if (null != this.data) {
            payload.getByteBuf().writeZero(4);
            int index = payload.getByteBuf().readableBytes();
            this.data.write((PacketPayload)payload);
            int length = payload.getByteBuf().readableBytes() - index;
            payload.getByteBuf().setInt(index - 4, length);
            payload.getByteBuf().writeBytes(new byte[4 - length & 3]);
        } else {
            payload.writeInt4(0);
        }
        if (null != this.statusVector) {
            this.statusVector.write((PacketPayload)payload);
        } else {
            payload.getByteBuf().writeZero(4);
        }
    }

    @Generated
    public int getHandle() {
        return this.handle;
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public FirebirdPacket getData() {
        return this.data;
    }

    @Generated
    public FirebirdStatusVector getStatusVector() {
        return this.statusVector;
    }

    @Generated
    public boolean isWriteZeroStatementId() {
        return this.writeZeroStatementId;
    }
}

