/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.refresher.pushdown.type.schema;

import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.mode.metadata.refresher.pushdown.PushDownMetaDataRefresher;
import org.apache.shardingsphere.mode.persist.service.MetaDataManagerPersistService;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.schema.DropSchemaStatement;

public final class DropSchemaPushDownMetaDataRefresher
implements PushDownMetaDataRefresher<DropSchemaStatement> {
    @Override
    public void refresh(MetaDataManagerPersistService metaDataManagerPersistService, ShardingSphereDatabase database, String logicDataSourceName, String schemaName, DatabaseType databaseType, DropSchemaStatement sqlStatement, ConfigurationProperties props) {
        metaDataManagerPersistService.dropSchema(database, this.getSchemaNames(sqlStatement));
    }

    private Collection<String> getSchemaNames(DropSchemaStatement sqlStatement) {
        return sqlStatement.getSchemaNames().stream().map(each -> each.getValue().toLowerCase()).collect(Collectors.toList());
    }

    @Override
    public Class<DropSchemaStatement> getType() {
        return DropSchemaStatement.class;
    }
}

