/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.engine.database.type;

import java.util.Objects;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.engine.database.DatabaseRuleOperator;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.type.DatabaseRuleDropExecutor;
import org.apache.shardingsphere.distsql.statement.type.rdl.rule.aware.StaticDataSourceContainedRuleAwareStatement;
import org.apache.shardingsphere.distsql.statement.type.rdl.rule.database.DatabaseRuleDefinitionStatement;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.config.rule.checker.DatabaseRuleConfigurationEmptyChecker;
import org.apache.shardingsphere.infra.config.rule.scope.DatabaseRuleConfiguration;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.attribute.datasource.StaticDataSourceRuleAttribute;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.infra.yaml.config.pojo.rule.YamlRuleConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapperEngine;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.node.rule.tuple.annotation.RuleNodeTupleEntity;
import org.apache.shardingsphere.mode.persist.service.MetaDataManagerPersistService;

public final class DropDatabaseRuleOperator
implements DatabaseRuleOperator {
    private final ContextManager contextManager;
    private final DatabaseRuleDropExecutor executor;

    @Override
    public void operate(DatabaseRuleDefinitionStatement sqlStatement, ShardingSphereDatabase database, RuleConfiguration currentRuleConfig) {
        if (!this.executor.hasAnyOneToBeDropped(sqlStatement)) {
            return;
        }
        if (sqlStatement instanceof StaticDataSourceContainedRuleAwareStatement) {
            for (StaticDataSourceRuleAttribute each : database.getRuleMetaData().getAttributes(StaticDataSourceRuleAttribute.class)) {
                ((StaticDataSourceContainedRuleAwareStatement)sqlStatement).getNames().forEach(arg_0 -> ((StaticDataSourceRuleAttribute)each).cleanStorageNodeDataSource(arg_0));
            }
        }
        MetaDataManagerPersistService metaDataManagerPersistService = this.contextManager.getPersistServiceFacade().getModeFacade().getMetaDataManagerService();
        Object toBeDroppedRuleItemConfig = this.executor.buildToBeDroppedRuleConfiguration(sqlStatement);
        metaDataManagerPersistService.removeRuleConfigurationItem(database, toBeDroppedRuleItemConfig);
        Object toBeAlteredRuleConfig = this.executor.buildToBeAlteredRuleConfiguration(sqlStatement);
        if (null != toBeAlteredRuleConfig) {
            if (((DatabaseRuleConfigurationEmptyChecker)TypedSPILoader.getService(DatabaseRuleConfigurationEmptyChecker.class, toBeAlteredRuleConfig.getClass())).isEmpty((DatabaseRuleConfiguration)toBeAlteredRuleConfig)) {
                YamlRuleConfiguration yamlRuleConfig = new YamlRuleConfigurationSwapperEngine().swapToYamlRuleConfiguration(currentRuleConfig);
                metaDataManagerPersistService.removeRuleConfiguration(database, currentRuleConfig, Objects.requireNonNull(yamlRuleConfig.getClass().getAnnotation(RuleNodeTupleEntity.class)).value());
            } else {
                metaDataManagerPersistService.alterRuleConfiguration(database, toBeAlteredRuleConfig);
            }
        }
    }

    @Generated
    public DropDatabaseRuleOperator(ContextManager contextManager, DatabaseRuleDropExecutor executor) {
        this.contextManager = contextManager;
        this.executor = executor;
    }
}

