/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.mysql.constant;

import lombok.Generated;

public enum MySQLCapabilityFlag {
    CLIENT_LONG_PASSWORD(1),
    CLIENT_FOUND_ROWS(2),
    CLIENT_LONG_FLAG(4),
    CLIENT_CONNECT_WITH_DB(8),
    CLIENT_NO_SCHEMA(16),
    CLIENT_COMPRESS(32),
    CLIENT_ODBC(64),
    CLIENT_LOCAL_FILES(128),
    CLIENT_IGNORE_SPACE(256),
    CLIENT_PROTOCOL_41(512),
    CLIENT_INTERACTIVE(1024),
    CLIENT_SSL(2048),
    CLIENT_IGNORE_SIGPIPE(4096),
    CLIENT_TRANSACTIONS(8192),
    CLIENT_RESERVED(16384),
    CLIENT_SECURE_CONNECTION(32768),
    CLIENT_MULTI_STATEMENTS(65536),
    CLIENT_MULTI_RESULTS(131072),
    CLIENT_PS_MULTI_RESULTS(262144),
    CLIENT_PLUGIN_AUTH(524288),
    CLIENT_CONNECT_ATTRS(0x100000),
    CLIENT_PLUGIN_AUTH_LENENC_CLIENT_DATA(0x200000),
    CLIENT_CAN_HANDLE_EXPIRED_PASSWORDS(0x400000),
    CLIENT_SESSION_TRACK(0x800000),
    CLIENT_DEPRECATE_EOF(0x1000000);

    private final int value;

    public static int calculateHandshakeCapabilityFlagsLower() {
        return MySQLCapabilityFlag.calculateCapabilityFlags(CLIENT_LONG_PASSWORD, CLIENT_FOUND_ROWS, CLIENT_LONG_FLAG, CLIENT_CONNECT_WITH_DB, CLIENT_ODBC, CLIENT_IGNORE_SPACE, CLIENT_PROTOCOL_41, CLIENT_INTERACTIVE, CLIENT_IGNORE_SIGPIPE, CLIENT_TRANSACTIONS, CLIENT_SECURE_CONNECTION) & 0xFFFF;
    }

    public static int calculateHandshakeCapabilityFlagsUpper() {
        return MySQLCapabilityFlag.calculateCapabilityFlags(CLIENT_MULTI_STATEMENTS, CLIENT_PLUGIN_AUTH, CLIENT_MULTI_RESULTS, CLIENT_PS_MULTI_RESULTS) >> 16;
    }

    public static int calculateCapabilityFlags(MySQLCapabilityFlag ... capabilities) {
        int result = 0;
        for (MySQLCapabilityFlag each : capabilities) {
            result |= each.value;
        }
        return result;
    }

    @Generated
    private MySQLCapabilityFlag(int value) {
        this.value = value;
    }

    @Generated
    public int getValue() {
        return this.value;
    }
}

