/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.cdc.api;

import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.type.ShardingSpherePipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.type.StandardPipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.cdc.CDCJob;
import org.apache.shardingsphere.data.pipeline.cdc.CDCJobId;
import org.apache.shardingsphere.data.pipeline.cdc.CDCJobType;
import org.apache.shardingsphere.data.pipeline.cdc.api.StreamDataParameter;
import org.apache.shardingsphere.data.pipeline.cdc.config.CDCJobConfiguration;
import org.apache.shardingsphere.data.pipeline.cdc.config.yaml.config.YamlCDCJobConfiguration;
import org.apache.shardingsphere.data.pipeline.cdc.config.yaml.swapper.YamlCDCJobConfigurationSwapper;
import org.apache.shardingsphere.data.pipeline.cdc.constant.CDCSinkType;
import org.apache.shardingsphere.data.pipeline.cdc.core.pojo.CDCJobItemInfo;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContextKey;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContextManager;
import org.apache.shardingsphere.data.pipeline.core.datanode.JobDataNodeEntry;
import org.apache.shardingsphere.data.pipeline.core.datanode.JobDataNodeLine;
import org.apache.shardingsphere.data.pipeline.core.datanode.JobDataNodeLineConvertUtils;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSourceManager;
import org.apache.shardingsphere.data.pipeline.core.datasource.config.PipelineDataSourceConfigurationFactory;
import org.apache.shardingsphere.data.pipeline.core.datasource.yaml.swapper.YamlPipelineDataSourceConfigurationSwapper;
import org.apache.shardingsphere.data.pipeline.core.exception.job.PipelineJobCreationWithInvalidShardingCountException;
import org.apache.shardingsphere.data.pipeline.core.exception.job.PrepareJobWithGetBinlogPositionException;
import org.apache.shardingsphere.data.pipeline.core.importer.sink.PipelineSink;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.DumperCommonContext;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.incremental.IncrementalDumperContext;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.mapper.TableAndSchemaNameMapper;
import org.apache.shardingsphere.data.pipeline.core.job.PipelineJob;
import org.apache.shardingsphere.data.pipeline.core.job.PipelineJobRegistry;
import org.apache.shardingsphere.data.pipeline.core.job.api.PipelineAPIFactory;
import org.apache.shardingsphere.data.pipeline.core.job.api.TransmissionJobAPI;
import org.apache.shardingsphere.data.pipeline.core.job.config.PipelineJobConfiguration;
import org.apache.shardingsphere.data.pipeline.core.job.id.PipelineJobId;
import org.apache.shardingsphere.data.pipeline.core.job.id.PipelineJobIdUtils;
import org.apache.shardingsphere.data.pipeline.core.job.progress.JobItemIncrementalTasksProgress;
import org.apache.shardingsphere.data.pipeline.core.job.progress.TransmissionJobItemProgress;
import org.apache.shardingsphere.data.pipeline.core.job.progress.yaml.swapper.YamlPipelineJobItemProgressSwapper;
import org.apache.shardingsphere.data.pipeline.core.job.service.PipelineJobConfigurationManager;
import org.apache.shardingsphere.data.pipeline.core.job.service.PipelineJobItemManager;
import org.apache.shardingsphere.data.pipeline.core.job.service.PipelineJobManager;
import org.apache.shardingsphere.data.pipeline.core.job.service.TransmissionJobManager;
import org.apache.shardingsphere.data.pipeline.core.job.type.PipelineJobType;
import org.apache.shardingsphere.data.pipeline.core.pojo.TransmissionJobItemInfo;
import org.apache.shardingsphere.data.pipeline.core.preparer.incremental.IncrementalTaskPositionManager;
import org.apache.shardingsphere.data.pipeline.core.registrycenter.repository.PipelineGovernanceFacade;
import org.apache.shardingsphere.data.pipeline.core.task.progress.IncrementalTaskProgress;
import org.apache.shardingsphere.elasticjob.api.ElasticJob;
import org.apache.shardingsphere.elasticjob.infra.pojo.JobConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.lite.api.bootstrap.JobBootstrap;
import org.apache.shardingsphere.elasticjob.lite.api.bootstrap.impl.OneOffJobBootstrap;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.instance.metadata.InstanceType;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.util.datetime.DateTimeFormatterFactory;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.config.pojo.YamlRootConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.resource.YamlDataSourceConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapperEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CDCJobAPI
implements TransmissionJobAPI {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CDCJobAPI.class);
    private final CDCJobType jobType = new CDCJobType();
    private final PipelineJobManager jobManager = new PipelineJobManager((PipelineJobType)this.jobType);
    private final PipelineJobConfigurationManager jobConfigManager = new PipelineJobConfigurationManager(this.jobType.getOption());
    private final YamlDataSourceConfigurationSwapper dataSourceConfigSwapper = new YamlDataSourceConfigurationSwapper();
    private final YamlRuleConfigurationSwapperEngine ruleConfigSwapperEngine = new YamlRuleConfigurationSwapperEngine();
    private final YamlPipelineDataSourceConfigurationSwapper pipelineDataSourceConfigSwapper = new YamlPipelineDataSourceConfigurationSwapper();

    public String create(StreamDataParameter param, CDCSinkType sinkType, Properties sinkProps) {
        PipelineContextKey contextKey = new PipelineContextKey(param.getDatabaseName(), InstanceType.PROXY);
        YamlCDCJobConfiguration yamlJobConfig = this.getYamlCDCJobConfiguration(param, sinkType, sinkProps, contextKey);
        CDCJobConfiguration jobConfig = new YamlCDCJobConfigurationSwapper().swapToObject(yamlJobConfig);
        ShardingSpherePreconditions.checkState((0 != jobConfig.getJobShardingCount() ? 1 : 0) != 0, () -> new PipelineJobCreationWithInvalidShardingCountException(jobConfig.getJobId()));
        PipelineGovernanceFacade governanceFacade = PipelineAPIFactory.getPipelineGovernanceFacade((PipelineContextKey)PipelineJobIdUtils.parseContextKey((String)jobConfig.getJobId()));
        if (governanceFacade.getJobFacade().getConfiguration().isExisted(jobConfig.getJobId())) {
            log.warn("CDC job already exists in registry center, ignore, job id is `{}`", (Object)jobConfig.getJobId());
        } else {
            governanceFacade.getJobFacade().getJob().create(jobConfig.getJobId(), this.jobType.getOption().getJobClass());
            JobConfigurationPOJO jobConfigPOJO = this.jobConfigManager.convertToJobConfigurationPOJO((PipelineJobConfiguration)jobConfig);
            jobConfigPOJO.setDisabled(true);
            governanceFacade.getJobFacade().getConfiguration().persist(jobConfig.getJobId(), jobConfigPOJO);
            if (!param.isFull()) {
                this.initIncrementalPosition(jobConfig);
            }
        }
        return jobConfig.getJobId();
    }

    private YamlCDCJobConfiguration getYamlCDCJobConfiguration(StreamDataParameter param, CDCSinkType sinkType, Properties sinkProps, PipelineContextKey contextKey) {
        YamlCDCJobConfiguration result = new YamlCDCJobConfiguration();
        List<String> schemaTableNames = param.getSchemaTableNames();
        Collections.sort(schemaTableNames);
        result.setJobId(PipelineJobIdUtils.marshal((PipelineJobId)new CDCJobId(contextKey, schemaTableNames, param.isFull(), sinkType)));
        result.setDatabaseName(param.getDatabaseName());
        result.setSchemaTableNames(schemaTableNames);
        result.setFull(param.isFull());
        result.setDecodeWithTX(param.isDecodeWithTransaction());
        YamlCDCJobConfiguration.YamlSinkConfiguration sinkConfig = new YamlCDCJobConfiguration.YamlSinkConfiguration();
        sinkConfig.setSinkType(sinkType.name());
        sinkConfig.setProps(sinkProps);
        result.setSinkConfig(sinkConfig);
        ShardingSphereDatabase database = PipelineContextManager.getContext((PipelineContextKey)contextKey).getMetaDataContexts().getMetaData().getDatabase(param.getDatabaseName());
        result.setDataSourceConfiguration(this.pipelineDataSourceConfigSwapper.swapToYamlConfiguration((PipelineDataSourceConfiguration)this.getDataSourceConfiguration(database)));
        List jobDataNodeLines = JobDataNodeLineConvertUtils.convertDataNodesToLines(param.getTableAndDataNodesMap());
        result.setJobShardingDataNodes(jobDataNodeLines.stream().map(JobDataNodeLine::marshal).collect(Collectors.toList()));
        JobDataNodeLine tableFirstDataNodes = new JobDataNodeLine(param.getTableAndDataNodesMap().entrySet().stream().map(entry -> new JobDataNodeEntry((String)entry.getKey(), ((List)entry.getValue()).subList(0, 1))).collect(Collectors.toList()));
        result.setTablesFirstDataNodes(tableFirstDataNodes.marshal());
        result.setSourceDatabaseType(PipelineDataSourceConfigurationFactory.newInstance((String)result.getDataSourceConfiguration().getType(), (String)result.getDataSourceConfiguration().getParameter()).getDatabaseType().getType());
        return result;
    }

    private ShardingSpherePipelineDataSourceConfiguration getDataSourceConfiguration(ShardingSphereDatabase database) {
        HashMap<String, Map> dataSourcePoolProps = new HashMap<String, Map>(database.getResourceMetaData().getStorageUnits().size(), 1.0f);
        for (Map.Entry entry : database.getResourceMetaData().getStorageUnits().entrySet()) {
            dataSourcePoolProps.put((String)entry.getKey(), this.dataSourceConfigSwapper.swapToMap(((StorageUnit)entry.getValue()).getDataSourcePoolProperties()));
        }
        YamlRootConfiguration targetRootConfig = new YamlRootConfiguration();
        targetRootConfig.setDatabaseName(database.getName());
        targetRootConfig.setDataSources(dataSourcePoolProps);
        targetRootConfig.setRules(this.ruleConfigSwapperEngine.swapToYamlRuleConfigurations(database.getRuleMetaData().getConfigurations()));
        return new ShardingSpherePipelineDataSourceConfiguration(targetRootConfig);
    }

    private void initIncrementalPosition(CDCJobConfiguration jobConfig) {
        String jobId = jobConfig.getJobId();
        PipelineJobItemManager jobItemManager = new PipelineJobItemManager(this.jobType.getOption().getYamlJobItemProgressSwapper());
        try (PipelineDataSourceManager pipelineDataSourceManager = new PipelineDataSourceManager();){
            for (int i = 0; i < jobConfig.getJobShardingCount(); ++i) {
                if (jobItemManager.getProgress(jobId, i).isPresent()) continue;
                IncrementalDumperContext dumperContext = this.buildDumperContext(jobConfig, i, new TableAndSchemaNameMapper(jobConfig.getSchemaTableNames()));
                TransmissionJobItemProgress jobItemProgress = this.getTransmissionJobItemProgress(jobConfig, pipelineDataSourceManager, dumperContext);
                YamlPipelineJobItemProgressSwapper swapper = this.jobType.getOption().getYamlJobItemProgressSwapper();
                PipelineAPIFactory.getPipelineGovernanceFacade((PipelineContextKey)PipelineJobIdUtils.parseContextKey((String)jobId)).getJobItemFacade().getProcess().persist(jobId, i, YamlEngine.marshal((Object)swapper.swapToYamlConfiguration((Object)jobItemProgress)));
            }
        }
        catch (SQLException ex) {
            throw new PrepareJobWithGetBinlogPositionException(jobId, ex);
        }
    }

    private IncrementalDumperContext buildDumperContext(CDCJobConfiguration jobConfig, int jobShardingItem, TableAndSchemaNameMapper tableAndSchemaNameMapper) {
        JobDataNodeLine dataNodeLine = jobConfig.getJobShardingDataNodes().get(jobShardingItem);
        String dataSourceName = ((DataNode)((JobDataNodeEntry)dataNodeLine.getEntries().iterator().next()).getDataNodes().iterator().next()).getDataSourceName();
        StandardPipelineDataSourceConfiguration actualDataSourceConfig = jobConfig.getDataSourceConfig().getActualDataSourceConfiguration(dataSourceName);
        return new IncrementalDumperContext(new DumperCommonContext(dataSourceName, (PipelineDataSourceConfiguration)actualDataSourceConfig, JobDataNodeLineConvertUtils.buildTableNameMapper((JobDataNodeLine)dataNodeLine), tableAndSchemaNameMapper), jobConfig.getJobId(), jobConfig.isDecodeWithTX());
    }

    private TransmissionJobItemProgress getTransmissionJobItemProgress(CDCJobConfiguration jobConfig, PipelineDataSourceManager dataSourceManager, IncrementalDumperContext incrementalDumperContext) throws SQLException {
        TransmissionJobItemProgress result = new TransmissionJobItemProgress();
        result.setSourceDatabaseType(jobConfig.getSourceDatabaseType());
        result.setDataSourceName(incrementalDumperContext.getCommonContext().getDataSourceName());
        IncrementalTaskPositionManager positionManager = new IncrementalTaskPositionManager(incrementalDumperContext.getCommonContext().getDataSourceConfig().getDatabaseType());
        IncrementalTaskProgress incrementalTaskProgress = new IncrementalTaskProgress(positionManager.getPosition(null, incrementalDumperContext, dataSourceManager));
        result.setIncremental(new JobItemIncrementalTasksProgress(incrementalTaskProgress));
        return result;
    }

    public void start(String jobId, PipelineSink sink) {
        CDCJob job = new CDCJob(sink);
        PipelineJobRegistry.add((String)jobId, (PipelineJob)job);
        this.enable(jobId);
        JobConfigurationPOJO jobConfigPOJO = PipelineJobIdUtils.getElasticJobConfigurationPOJO((String)jobId);
        OneOffJobBootstrap oneOffJobBootstrap = new OneOffJobBootstrap(PipelineAPIFactory.getRegistryCenter((PipelineContextKey)PipelineJobIdUtils.parseContextKey((String)jobId)), (ElasticJob)job, jobConfigPOJO.toJobConfiguration());
        job.getJobRunnerManager().setJobBootstrap((JobBootstrap)oneOffJobBootstrap);
        oneOffJobBootstrap.execute();
    }

    private void enable(String jobId) {
        JobConfigurationPOJO jobConfigPOJO = PipelineJobIdUtils.getElasticJobConfigurationPOJO((String)jobId);
        jobConfigPOJO.setDisabled(false);
        jobConfigPOJO.getProps().setProperty("start_time_millis", String.valueOf(System.currentTimeMillis()));
        jobConfigPOJO.getProps().remove("stop_time");
        PipelineAPIFactory.getJobConfigurationAPI((PipelineContextKey)PipelineJobIdUtils.parseContextKey((String)jobConfigPOJO.getJobName())).updateJobConfiguration(jobConfigPOJO);
    }

    public void disable(String jobId) {
        JobConfigurationPOJO jobConfigPOJO = PipelineJobIdUtils.getElasticJobConfigurationPOJO((String)jobId);
        jobConfigPOJO.setDisabled(true);
        jobConfigPOJO.getProps().setProperty("stop_time", LocalDateTime.now().format(DateTimeFormatterFactory.getDatetimeFormatter()));
        PipelineAPIFactory.getJobConfigurationAPI((PipelineContextKey)PipelineJobIdUtils.parseContextKey((String)jobConfigPOJO.getJobName())).updateJobConfiguration(jobConfigPOJO);
    }

    public void drop(String jobId) {
        CDCJobConfiguration jobConfig = (CDCJobConfiguration)this.jobConfigManager.getJobConfiguration(jobId);
        this.jobManager.drop(jobId);
        this.cleanup(jobConfig);
    }

    private void cleanup(CDCJobConfiguration jobConfig) {
        for (Map.Entry entry : jobConfig.getDataSourceConfig().getRootConfig().getDataSources().entrySet()) {
            try {
                StandardPipelineDataSourceConfiguration pipelineDataSourceConfig = new StandardPipelineDataSourceConfiguration((Map)entry.getValue());
                new IncrementalTaskPositionManager(pipelineDataSourceConfig.getDatabaseType()).destroyPosition(jobConfig.getJobId(), (PipelineDataSourceConfiguration)pipelineDataSourceConfig);
            }
            catch (SQLException ex) {
                log.warn("job destroying failed, jobId={}, dataSourceName={}", new Object[]{jobConfig.getJobId(), entry.getKey(), ex});
            }
        }
    }

    public Collection<CDCJobItemInfo> getJobItemInfos(String jobId) {
        CDCJobConfiguration jobConfig = (CDCJobConfiguration)new PipelineJobConfigurationManager(this.jobType.getOption()).getJobConfiguration(jobId);
        ShardingSphereDatabase database = PipelineContextManager.getProxyContext().getMetaDataContexts().getMetaData().getDatabase(jobConfig.getDatabaseName());
        LinkedList<CDCJobItemInfo> result = new LinkedList<CDCJobItemInfo>();
        for (TransmissionJobItemInfo each : new TransmissionJobManager((PipelineJobType)this.jobType).getJobItemInfos(jobId)) {
            TransmissionJobItemProgress jobItemProgress = each.getJobItemProgress();
            String confirmedPosition = null == jobItemProgress ? "" : jobItemProgress.getIncremental().getIncrementalPosition().map(Object::toString).orElse("");
            String currentPosition = null == jobItemProgress ? "" : this.getCurrentPosition(database, jobItemProgress.getDataSourceName());
            result.add(new CDCJobItemInfo(each, confirmedPosition, currentPosition));
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    private String getCurrentPosition(ShardingSphereDatabase database, String dataSourceName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void commit(String jobId) {
    }

    public void rollback(String jobId) {
    }

    public String getType() {
        return "STREAMING";
    }
}

