/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.cdc.util;

import com.google.common.base.Strings;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.cdc.protocol.response.DataRecordResult;
import org.apache.shardingsphere.data.pipeline.cdc.protocol.response.TableColumn;
import org.apache.shardingsphere.data.pipeline.cdc.util.ColumnValueConvertUtils;
import org.apache.shardingsphere.data.pipeline.core.constant.PipelineSQLOperationType;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.Column;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.DataRecord;

public final class DataRecordResultConvertUtils {
    public static DataRecordResult.Record convertDataRecordToRecord(String database, String schema, DataRecord dataRecord) {
        LinkedList<TableColumn> before = new LinkedList<TableColumn>();
        LinkedList<TableColumn> after = new LinkedList<TableColumn>();
        for (Column column : dataRecord.getColumns()) {
            before.add(TableColumn.newBuilder().setName(column.getName()).setValue(Any.pack((Message)ColumnValueConvertUtils.convertToProtobufMessage(column.getOldValue()))).build());
            after.add(TableColumn.newBuilder().setName(column.getName()).setValue(Any.pack((Message)ColumnValueConvertUtils.convertToProtobufMessage(column.getValue()))).build());
        }
        DataRecordResult.Record.MetaData metaData = DataRecordResult.Record.MetaData.newBuilder().setDatabase(database).setSchema(Strings.nullToEmpty((String)schema)).setTable(dataRecord.getTableName()).build();
        return DataRecordResult.Record.newBuilder().setMetaData(metaData).addAllBefore(before).addAllAfter(after).setTransactionCommitMillis(dataRecord.getCommitTime()).setDataChangeType(DataRecordResultConvertUtils.getDataChangeType(dataRecord.getType())).build();
    }

    private static DataRecordResult.Record.DataChangeType getDataChangeType(PipelineSQLOperationType type) {
        switch (type) {
            case INSERT: {
                return DataRecordResult.Record.DataChangeType.INSERT;
            }
            case UPDATE: {
                return DataRecordResult.Record.DataChangeType.UPDATE;
            }
            case DELETE: {
                return DataRecordResult.Record.DataChangeType.DELETE;
            }
        }
        return DataRecordResult.Record.DataChangeType.UNKNOWN;
    }

    @Generated
    private DataRecordResultConvertUtils() {
    }
}

