/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.single.distsql.handler.update;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.DialectDatabaseMetaData;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.database.exception.core.exception.syntax.table.TableExistsException;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.type.DatabaseRuleCreateExecutor;
import org.apache.shardingsphere.infra.database.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.TableNotFoundException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.datanode.InvalidDataNodeFormatException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.resource.storageunit.EmptyStorageUnitException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.resource.storageunit.InvalidStorageUnitStatusException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.PhysicalDataSourceAggregator;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.single.config.SingleRuleConfiguration;
import org.apache.shardingsphere.single.datanode.SingleTableDataNodeLoader;
import org.apache.shardingsphere.single.distsql.segment.SingleTableSegment;
import org.apache.shardingsphere.single.distsql.statement.rdl.LoadSingleTableStatement;
import org.apache.shardingsphere.single.rule.SingleRule;

public final class LoadSingleTableExecutor
implements DatabaseRuleCreateExecutor<LoadSingleTableStatement, SingleRule, SingleRuleConfiguration> {
    private ShardingSphereDatabase database;
    private SingleRule rule;

    public void checkBeforeUpdate(LoadSingleTableStatement sqlStatement) {
        Collection<String> storageUnitNames = this.getStorageUnitNames(sqlStatement);
        if (!storageUnitNames.isEmpty()) {
            ShardingSpherePreconditions.checkNotEmpty((Map)this.database.getResourceMetaData().getStorageUnits(), () -> new EmptyStorageUnitException(this.database.getName()));
            this.database.checkStorageUnitsExisted(storageUnitNames);
        }
        String defaultSchemaName = new DatabaseTypeRegistry(this.database.getProtocolType()).getDefaultSchemaName(this.database.getName());
        this.checkShouldNotExistLogicTables(sqlStatement, defaultSchemaName);
        if (!storageUnitNames.isEmpty()) {
            this.checkShouldExistActualTables(sqlStatement, storageUnitNames, defaultSchemaName);
        }
    }

    private Collection<String> getStorageUnitNames(LoadSingleTableStatement sqlStatement) {
        return sqlStatement.getTables().stream().map(SingleTableSegment::getStorageUnitName).filter(each -> !"*".equals(each)).collect(Collectors.toSet());
    }

    private void checkShouldNotExistLogicTables(LoadSingleTableStatement sqlStatement, String defaultSchemaName) {
        Collection tableSegments = sqlStatement.getTables();
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(this.database.getProtocolType()).getDialectDatabaseMetaData();
        boolean isSchemaSupportedDatabaseType = dialectDatabaseMetaData.getSchemaOption().getDefaultSchema().isPresent();
        ShardingSphereSchema schema = this.database.getSchema(defaultSchemaName);
        for (SingleTableSegment each : tableSegments) {
            this.checkTableNodeFormat(isSchemaSupportedDatabaseType, each);
            if ("*".equals(each.getTableName())) continue;
            ShardingSpherePreconditions.checkState((!schema.containsTable(each.getTableName()) ? 1 : 0) != 0, () -> new TableExistsException(each.getTableName()));
        }
    }

    private void checkTableNodeFormat(boolean isSchemaSupportedDatabaseType, SingleTableSegment singleTableSegment) {
        if ("*.*".equals(singleTableSegment.toString()) || "*.*.*".equals(singleTableSegment.toString())) {
            return;
        }
        if (isSchemaSupportedDatabaseType) {
            ShardingSpherePreconditions.checkState((boolean)singleTableSegment.getSchemaName().isPresent(), () -> new InvalidDataNodeFormatException(singleTableSegment.toString(), "Current database is schema required, please use format `db.schema.table`"));
        } else {
            ShardingSpherePreconditions.checkState((!singleTableSegment.getSchemaName().isPresent() ? 1 : 0) != 0, () -> new InvalidDataNodeFormatException(singleTableSegment.toString(), "Current database does not support schema, please use format `db.table`"));
        }
    }

    private void checkShouldExistActualTables(LoadSingleTableStatement sqlStatement, Collection<String> storageUnitNames, String defaultSchemaName) {
        Map<String, DataSource> dataSourceMap = this.database.getResourceMetaData().getStorageUnits().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((StorageUnit)entry.getValue()).getDataSource()));
        Map aggregatedDataSourceMap = PhysicalDataSourceAggregator.getAggregatedDataSources(dataSourceMap, (Collection)this.database.getRuleMetaData().getRules());
        Collection invalidDataSources = storageUnitNames.stream().filter(each -> !aggregatedDataSourceMap.containsKey(each)).collect(Collectors.toList());
        ShardingSpherePreconditions.checkState((boolean)invalidDataSources.isEmpty(), () -> new InvalidStorageUnitStatusException(String.format("`%s` is invalid, please use `%s`", String.join((CharSequence)",", invalidDataSources), String.join((CharSequence)",", aggregatedDataSourceMap.keySet()))));
        Map<String, Map<String, Collection<String>>> actualTableNodes = this.getActualTableNodes(storageUnitNames, aggregatedDataSourceMap);
        for (SingleTableSegment each2 : sqlStatement.getTables()) {
            String tableName = each2.getTableName();
            if ("*".equals(tableName)) continue;
            String storageUnitName = each2.getStorageUnitName();
            String schemaName = each2.getSchemaName().isPresent() ? (String)each2.getSchemaName().get() : defaultSchemaName;
            ShardingSpherePreconditions.checkState((actualTableNodes.containsKey(storageUnitName) && actualTableNodes.get(storageUnitName).get(schemaName).contains(tableName) ? 1 : 0) != 0, () -> new TableNotFoundException(tableName, storageUnitName));
        }
    }

    private Map<String, Map<String, Collection<String>>> getActualTableNodes(Collection<String> storageUnitNames, Map<String, DataSource> aggregatedDataSourceMap) {
        LinkedHashMap<String, Map<String, Collection<String>>> result = new LinkedHashMap<String, Map<String, Collection<String>>>(storageUnitNames.size(), 1.0f);
        for (String each : storageUnitNames) {
            DataSource dataSource = aggregatedDataSourceMap.get(each);
            Map schemaTableNames = SingleTableDataNodeLoader.loadSchemaTableNames((String)this.database.getName(), (DatabaseType)DatabaseTypeEngine.getStorageType((DataSource)dataSource), (DataSource)dataSource, (String)each, Collections.emptyList());
            if (schemaTableNames.isEmpty()) continue;
            result.put(each, schemaTableNames);
        }
        return result;
    }

    public SingleRuleConfiguration buildToBeCreatedRuleConfiguration(LoadSingleTableStatement sqlStatement) {
        SingleRuleConfiguration result = new SingleRuleConfiguration();
        if (null != this.rule) {
            result.getTables().addAll(this.rule.getConfiguration().getTables());
        }
        result.getTables().addAll(this.getRequiredTables(sqlStatement));
        return result;
    }

    private Collection<String> getRequiredTables(LoadSingleTableStatement sqlStatement) {
        if (null != this.rule) {
            return sqlStatement.getTables().stream().map(SingleTableSegment::toString).filter(each -> !this.rule.getConfiguration().getTables().contains(each)).collect(Collectors.toSet());
        }
        return sqlStatement.getTables().stream().map(SingleTableSegment::toString).collect(Collectors.toSet());
    }

    public Class<SingleRule> getRuleClass() {
        return SingleRule.class;
    }

    public Class<LoadSingleTableStatement> getType() {
        return LoadSingleTableStatement.class;
    }

    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }

    @Generated
    public void setRule(SingleRule rule) {
        this.rule = rule;
    }
}

