/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.segment.select.projection.engine;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.binder.context.segment.select.groupby.GroupByContext;
import org.apache.shardingsphere.infra.binder.context.segment.select.orderby.OrderByContext;
import org.apache.shardingsphere.infra.binder.context.segment.select.orderby.OrderByItem;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.DerivedColumn;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.ProjectionsContext;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.engine.ProjectionEngine;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.DerivedProjection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ShorthandProjection;
import org.apache.shardingsphere.sql.parser.statement.core.segment.SQLSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionsSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.IndexOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.OrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.TextOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.util.SQLUtils;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class ProjectionsContextEngine {
    private final ProjectionEngine projectionEngine;

    public ProjectionsContextEngine(DatabaseType databaseType) {
        this.projectionEngine = new ProjectionEngine(databaseType);
    }

    public ProjectionsContext createProjectionsContext(ProjectionsSegment projectionsSegment, GroupByContext groupByContext, OrderByContext orderByContext) {
        Collection<Projection> projections = this.getProjections(projectionsSegment);
        ProjectionsContext result = new ProjectionsContext(projectionsSegment.getStartIndex(), projectionsSegment.getStopIndex(), projectionsSegment.isDistinctRow(), projections);
        result.getProjections().addAll(this.getDerivedGroupByColumns(groupByContext, projections));
        result.getProjections().addAll(this.getDerivedOrderByColumns(orderByContext, projections));
        return result;
    }

    private Collection<Projection> getProjections(ProjectionsSegment projectionsSegment) {
        LinkedList<Projection> result = new LinkedList<Projection>();
        for (ProjectionSegment each : projectionsSegment.getProjections()) {
            this.projectionEngine.createProjection(each).ifPresent(result::add);
        }
        return result;
    }

    private Collection<Projection> getDerivedGroupByColumns(GroupByContext groupByContext, Collection<Projection> projections) {
        return this.getDerivedOrderColumns(groupByContext.getItems(), DerivedColumn.GROUP_BY_ALIAS, projections);
    }

    private Collection<Projection> getDerivedOrderByColumns(OrderByContext orderByContext, Collection<Projection> projections) {
        return this.getDerivedOrderColumns(orderByContext.getItems(), DerivedColumn.ORDER_BY_ALIAS, projections);
    }

    private Collection<Projection> getDerivedOrderColumns(Collection<OrderByItem> orderItems, DerivedColumn derivedColumn, Collection<Projection> projections) {
        LinkedList<Projection> result = new LinkedList<Projection>();
        int derivedColumnOffset = 0;
        for (OrderByItem each : orderItems) {
            if (this.containsProjection(each.getSegment(), projections)) continue;
            result.add(new DerivedProjection(((TextOrderByItemSegment)each.getSegment()).getText(), new IdentifierValue(derivedColumn.getDerivedColumnAlias(derivedColumnOffset++)), (SQLSegment)each.getSegment()));
        }
        return result;
    }

    private boolean containsProjection(OrderByItemSegment orderByItem, Collection<Projection> projections) {
        if (orderByItem instanceof IndexOrderByItemSegment) {
            return true;
        }
        for (Projection each : projections) {
            if (orderByItem instanceof ColumnOrderByItemSegment && this.isSameColumn(each, ((ColumnOrderByItemSegment)orderByItem).getColumn())) {
                return true;
            }
            String text = ((TextOrderByItemSegment)orderByItem).getText();
            if (!this.isSameAlias(each, text) && !this.isSameQualifiedName(each, text)) continue;
            return true;
        }
        return false;
    }

    private boolean isSameColumn(Projection projection, ColumnSegment columnSegment) {
        Collection<ColumnProjection> columns = this.getColumnProjections(projection);
        if (columns.isEmpty()) {
            return false;
        }
        boolean columnSegmentPresent = columnSegment.getOwner().isPresent();
        for (ColumnProjection each : columns) {
            if (!(columnSegmentPresent ? this.isSameQualifiedName(each, columnSegment.getQualifiedName()) : this.isSameName(each, columnSegment.getQualifiedName()))) continue;
            return true;
        }
        return false;
    }

    private Collection<ColumnProjection> getColumnProjections(Projection projection) {
        LinkedList<ColumnProjection> result = new LinkedList<ColumnProjection>();
        if (projection instanceof ColumnProjection) {
            result.add((ColumnProjection)projection);
        }
        if (projection instanceof ShorthandProjection) {
            result.addAll(((ShorthandProjection)projection).getColumnProjections());
        }
        return result;
    }

    private boolean isSameName(ColumnProjection projection, String text) {
        return SQLUtils.getExactlyValue((String)text).equalsIgnoreCase(projection.getName().getValue());
    }

    private boolean isSameAlias(Projection projection, String text) {
        return projection.getAlias().isPresent() && SQLUtils.getExactlyValue((String)text).equalsIgnoreCase(SQLUtils.getExactlyValue((String)projection.getAlias().get().getValue()));
    }

    private boolean isSameQualifiedName(Projection projection, String text) {
        return SQLUtils.getExactlyValue((String)text).equalsIgnoreCase(SQLUtils.getExactlyValue((String)projection.getExpression()));
    }
}

