/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.instance;

import com.google.errorprone.annotations.ThreadSafe;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.instance.ClusterInstanceRegistry;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.instance.workerid.WorkerIdGenerator;
import org.apache.shardingsphere.infra.state.instance.InstanceState;
import org.apache.shardingsphere.infra.util.eventbus.EventBusContext;

@ThreadSafe
public final class ComputeNodeInstanceContext {
    private final ComputeNodeInstance instance;
    private final ModeConfiguration modeConfiguration;
    private final EventBusContext eventBusContext;
    private final AtomicReference<WorkerIdGenerator> workerIdGenerator;
    private final ClusterInstanceRegistry clusterInstanceRegistry;

    public ComputeNodeInstanceContext(ComputeNodeInstance instance, ModeConfiguration modeConfiguration, EventBusContext eventBusContext) {
        this.instance = instance;
        this.modeConfiguration = modeConfiguration;
        this.eventBusContext = eventBusContext;
        this.workerIdGenerator = new AtomicReference();
        this.clusterInstanceRegistry = new ClusterInstanceRegistry();
    }

    public void init(WorkerIdGenerator workerIdGenerator) {
        this.workerIdGenerator.set(workerIdGenerator);
    }

    public void updateStatus(String instanceId, String status) {
        Optional<InstanceState> instanceState = InstanceState.get(status);
        if (!instanceState.isPresent()) {
            return;
        }
        if (this.instance.getMetaData().getId().equals(instanceId)) {
            this.instance.switchState(instanceState.get());
        }
        this.clusterInstanceRegistry.find(instanceId).ifPresent(optional -> optional.switchState((InstanceState)((Object)((Object)instanceState.get()))));
    }

    public void updateLabels(String instanceId, Collection<String> labels) {
        if (this.instance.getMetaData().getId().equals(instanceId)) {
            this.updateLabels(this.instance, labels);
        }
        this.clusterInstanceRegistry.find(instanceId).ifPresent(optional -> this.updateLabels((ComputeNodeInstance)optional, labels));
    }

    private void updateLabels(ComputeNodeInstance computeNodeInstance, Collection<String> labels) {
        computeNodeInstance.getLabels().clear();
        computeNodeInstance.getLabels().addAll(labels);
    }

    public void updateWorkerId(String instanceId, Integer workerId) {
        if (this.instance.getMetaData().getId().equals(instanceId)) {
            this.instance.setWorkerId(workerId);
        }
        this.clusterInstanceRegistry.find(instanceId).ifPresent(optional -> optional.setWorkerId(workerId));
    }

    public int getWorkerId() {
        return this.instance.getWorkerId();
    }

    public int generateWorkerId(Properties props) {
        ShardingSpherePreconditions.checkNotNull((Object)this.workerIdGenerator.get(), () -> new IllegalArgumentException("Worker id generator is not initialized."));
        int result = this.workerIdGenerator.get().generate(props);
        this.instance.setWorkerId(result);
        return result;
    }

    @Generated
    public ComputeNodeInstance getInstance() {
        return this.instance;
    }

    @Generated
    public ModeConfiguration getModeConfiguration() {
        return this.modeConfiguration;
    }

    @Generated
    public EventBusContext getEventBusContext() {
        return this.eventBusContext;
    }

    @Generated
    public ClusterInstanceRegistry getClusterInstanceRegistry() {
        return this.clusterInstanceRegistry;
    }
}

