/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.identifier;

import com.cedarsoftware.util.CaseInsensitiveMap;
import java.util.Objects;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.database.enums.QuoteCharacter;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.DialectDatabaseMetaData;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.option.IdentifierPatternType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class ShardingSphereIdentifier {
    private final CaseInsensitiveMap.CaseInsensitiveString value;
    private final String standardizeValue;
    private final boolean caseSensitive;

    public ShardingSphereIdentifier(String value) {
        this.value = null == value ? null : CaseInsensitiveMap.CaseInsensitiveString.of((String)value);
        this.standardizeValue = value;
        this.caseSensitive = false;
    }

    public ShardingSphereIdentifier(String value, DatabaseType databaseType) {
        this.value = null == value ? null : CaseInsensitiveMap.CaseInsensitiveString.of((String)value);
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData();
        this.standardizeValue = ShardingSphereIdentifier.standardizeValue(value, dialectDatabaseMetaData, false);
        this.caseSensitive = dialectDatabaseMetaData.isCaseSensitive();
    }

    public ShardingSphereIdentifier(IdentifierValue identifierValue, DatabaseType databaseType) {
        this.value = null == identifierValue.getValue() ? null : CaseInsensitiveMap.CaseInsensitiveString.of((String)identifierValue.getValue());
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData();
        this.standardizeValue = ShardingSphereIdentifier.standardizeValue(identifierValue.getValue(), dialectDatabaseMetaData, QuoteCharacter.NONE != identifierValue.getQuoteCharacter());
        this.caseSensitive = dialectDatabaseMetaData.isCaseSensitive();
    }

    private static String standardizeValue(String value, DialectDatabaseMetaData dialectDatabaseMetaData, boolean quoted) {
        if (null == value) {
            return null;
        }
        if (quoted) {
            return value;
        }
        IdentifierPatternType patternType = dialectDatabaseMetaData.getIdentifierPatternType();
        switch (patternType) {
            case UPPER_CASE: {
                return value.toUpperCase();
            }
            case LOWER_CASE: {
                return value.toLowerCase();
            }
        }
        return value;
    }

    public String getValue() {
        return null == this.value ? null : this.value.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ShardingSphereIdentifier)) {
            return false;
        }
        ShardingSphereIdentifier other = (ShardingSphereIdentifier)obj;
        if (null == this.getValue() && null == other.getValue()) {
            return true;
        }
        if (null == this.standardizeValue || null == other.getStandardizeValue()) {
            return false;
        }
        return this.caseSensitive ? this.standardizeValue.equals(other.getStandardizeValue()) : Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        if (null == this.standardizeValue) {
            return 0;
        }
        if (this.caseSensitive) {
            return this.standardizeValue.hashCode();
        }
        return null == this.value ? 0 : this.value.hashCode();
    }

    public String toString() {
        return this.getValue();
    }

    @Generated
    public String getStandardizeValue() {
        return this.standardizeValue;
    }
}

