/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.kernel.internal.annotation;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Optional;
import org.apache.shardingsphere.elasticjob.annotation.ElasticJobConfiguration;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;
import org.apache.shardingsphere.elasticjob.api.JobExtraConfigurationFactory;
import org.apache.shardingsphere.elasticjob.kernel.infra.exception.JobConfigurationException;

public final class JobAnnotationBuilder {
    public static JobConfiguration generateJobConfiguration(Class<?> type) {
        ElasticJobConfiguration annotation = type.getAnnotation(ElasticJobConfiguration.class);
        Preconditions.checkArgument((null != annotation ? 1 : 0) != 0, (String)"@ElasticJobConfiguration not found by class '%s'.", type);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)annotation.jobName()) ? 1 : 0) != 0, (String)"@ElasticJobConfiguration jobName could not be empty by class '%s'.", type);
        JobConfiguration.Builder jobConfigurationBuilder = JobConfiguration.newBuilder((String)annotation.jobName(), (int)annotation.shardingTotalCount()).shardingItemParameters(annotation.shardingItemParameters()).cron(Strings.isNullOrEmpty((String)annotation.cron()) ? null : annotation.cron()).timeZone(Strings.isNullOrEmpty((String)annotation.timeZone()) ? null : annotation.timeZone()).jobParameter(annotation.jobParameter()).monitorExecution(annotation.monitorExecution()).failover(annotation.failover()).misfire(annotation.misfire()).maxTimeDiffSeconds(annotation.maxTimeDiffSeconds()).reconcileIntervalMinutes(annotation.reconcileIntervalMinutes()).jobShardingStrategyType(Strings.isNullOrEmpty((String)annotation.jobShardingStrategyType()) ? null : annotation.jobShardingStrategyType()).jobExecutorThreadPoolSizeProviderType(Strings.isNullOrEmpty((String)annotation.jobExecutorThreadPoolSizeProviderType()) ? null : annotation.jobExecutorThreadPoolSizeProviderType()).jobErrorHandlerType(Strings.isNullOrEmpty((String)annotation.jobErrorHandlerType()) ? null : annotation.jobErrorHandlerType()).jobListenerTypes(annotation.jobListenerTypes()).description(annotation.description()).disabled(annotation.disabled()).overwrite(annotation.overwrite());
        for (Class clazz : annotation.extraConfigurations()) {
            try {
                Optional jobExtraConfig = ((JobExtraConfigurationFactory)clazz.newInstance()).getJobExtraConfiguration();
                jobExtraConfig.ifPresent(arg_0 -> ((JobConfiguration.Builder)jobConfigurationBuilder).addExtraConfigurations(arg_0));
            }
            catch (IllegalAccessException | InstantiationException exception) {
                throw (JobConfigurationException)new JobConfigurationException("new JobExtraConfigurationFactory instance by class '%s' failure", clazz).initCause(exception);
            }
        }
        for (Class clazz : annotation.props()) {
            jobConfigurationBuilder.setProperty(clazz.key(), clazz.value());
        }
        return jobConfigurationBuilder.build();
    }
}

