/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.kernel.internal.sharding;

import org.apache.shardingsphere.elasticjob.kernel.infra.yaml.YamlEngine;
import org.apache.shardingsphere.elasticjob.kernel.internal.config.ConfigurationNode;
import org.apache.shardingsphere.elasticjob.kernel.internal.config.JobConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.kernel.internal.listener.AbstractListenerManager;
import org.apache.shardingsphere.elasticjob.kernel.internal.sharding.ExecutionService;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.reg.listener.DataChangedEvent;
import org.apache.shardingsphere.elasticjob.reg.listener.DataChangedEventListener;

public final class MonitorExecutionListenerManager
extends AbstractListenerManager {
    private final ExecutionService executionService;
    private final ConfigurationNode configNode;

    public MonitorExecutionListenerManager(CoordinatorRegistryCenter regCenter, String jobName) {
        super(regCenter, jobName);
        this.executionService = new ExecutionService(regCenter, jobName);
        this.configNode = new ConfigurationNode(jobName);
    }

    @Override
    public void start() {
        this.addDataListener(new MonitorExecutionSettingsChangedJobListener());
    }

    class MonitorExecutionSettingsChangedJobListener
    implements DataChangedEventListener {
        MonitorExecutionSettingsChangedJobListener() {
        }

        public void onChange(DataChangedEvent event) {
            if (MonitorExecutionListenerManager.this.configNode.isConfigPath(event.getKey()) && DataChangedEvent.Type.UPDATED == event.getType() && !YamlEngine.unmarshal(event.getValue(), JobConfigurationPOJO.class).toJobConfiguration().isMonitorExecution()) {
                MonitorExecutionListenerManager.this.executionService.clearAllRunningInfo();
            }
        }
    }
}

