/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.integration.util.CollectionFilter;

public class AcceptOnceCollectionFilter<T>
implements CollectionFilter<T> {
    private volatile Collection<T> lastSeenElements = Collections.emptyList();
    private final Lock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<T> filter(Collection<T> unfilteredElements) {
        this.lock.lock();
        try {
            ArrayList<T> filteredElements = new ArrayList<T>();
            for (T element : unfilteredElements) {
                if (this.lastSeenElements.contains(element)) continue;
                filteredElements.add(element);
            }
            this.lastSeenElements = unfilteredElements;
            ArrayList<T> arrayList = filteredElements;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }
}

