/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config.impl;

import com.alibaba.nacos.api.config.ConfigChangeItem;
import com.alibaba.nacos.api.config.PropertyChangeType;
import com.alibaba.nacos.api.config.listener.ConfigChangeParser;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractConfigChangeParser
implements ConfigChangeParser {
    private final String configType;

    public AbstractConfigChangeParser(String configType) {
        this.configType = configType;
    }

    @Override
    public boolean isResponsibleFor(String type) {
        return this.configType.equalsIgnoreCase(type);
    }

    protected Map<String, ConfigChangeItem> filterChangeData(Map oldMap, Map newMap) {
        ConfigChangeItem cci;
        HashMap<String, ConfigChangeItem> result = new HashMap<String, ConfigChangeItem>(16);
        for (Map.Entry entry : oldMap.entrySet()) {
            if (newMap.containsKey(entry.getKey())) {
                if (entry.getValue().equals(newMap.get(entry.getKey()))) continue;
                cci = new ConfigChangeItem((String)entry.getKey(), entry.getValue().toString(), newMap.get(entry.getKey()).toString());
                cci.setType(PropertyChangeType.MODIFIED);
            } else {
                cci = new ConfigChangeItem((String)entry.getKey(), entry.getValue().toString(), null);
                cci.setType(PropertyChangeType.DELETED);
            }
            result.put((String)entry.getKey(), cci);
        }
        for (Map.Entry entry : newMap.entrySet()) {
            if (oldMap.containsKey(entry.getKey())) continue;
            cci = new ConfigChangeItem((String)entry.getKey(), null, entry.getValue().toString());
            cci.setType(PropertyChangeType.ADDED);
            result.put((String)entry.getKey(), cci);
        }
        return result;
    }
}

