/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.logging.log4j2;

import com.tencent.polaris.logging.AbstractPolarisLogging;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.LoggerConfig;

public class Log4j2PolarisLogging
extends AbstractPolarisLogging {
    private static final String LOG4J2_LOCATION = "classpath:polaris-log4j2.xml";
    private static final String FILE_PROTOCOL = "file";
    private static final String LOGGER_PREFIX = "com.tencent.polaris";
    private final String location = this.getLocation("classpath:polaris-log4j2.xml");

    @Override
    public void loadConfiguration() {
        if (null == this.location || this.location.trim().length() == 0) {
            return;
        }
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration contextConfiguration = loggerContext.getConfiguration();
        Configuration configuration = this.loadConfiguration(loggerContext, this.location);
        configuration.start();
        Map appenders = configuration.getAppenders();
        for (Appender appender : appenders.values()) {
            contextConfiguration.addAppender(appender);
        }
        Map loggers = configuration.getLoggers();
        for (String name : loggers.keySet()) {
            if (!name.startsWith(LOGGER_PREFIX) && !name.contains("polaris-update-event")) continue;
            contextConfiguration.addLogger(name, (LoggerConfig)loggers.get(name));
        }
        loggerContext.updateLoggers();
    }

    private Configuration loadConfiguration(LoggerContext loggerContext, String location) {
        try {
            URL url = Log4j2PolarisLogging.getResourceUrl(location);
            ConfigurationSource source2 = this.getConfigurationSource(url);
            return ConfigurationFactory.getInstance().getConfiguration(loggerContext, source2);
        }
        catch (Exception e) {
            throw new IllegalStateException("could not initialize log4j2 logging from " + location, e);
        }
    }

    private ConfigurationSource getConfigurationSource(URL url) throws IOException {
        InputStream stream = url.openStream();
        if (FILE_PROTOCOL.equals(url.getProtocol())) {
            return new ConfigurationSource(stream, Log4j2PolarisLogging.getResourceAsFile(url));
        }
        return new ConfigurationSource(stream, url);
    }
}

