/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.key.auth;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.rule.impl.KeyAuthRuleHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.key.auth.handler.KeyAuthPluginDataHandler;
import org.springframework.http.HttpHeaders;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class KeyAuthPlugin
extends AbstractShenyuPlugin {
    public int getOrder() {
        return PluginEnum.KEY_AUTH.getCode();
    }

    public String named() {
        return PluginEnum.KEY_AUTH.getName();
    }

    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        KeyAuthRuleHandle keyAuthRuleHandle = (KeyAuthRuleHandle)KeyAuthPluginDataHandler.CACHED_HANDLE.get().obtainHandle((Object)CacheKeyUtils.INST.getKey(rule));
        if (Objects.isNull(keyAuthRuleHandle) || StringUtils.isBlank((CharSequence)keyAuthRuleHandle.getKeyName()) || StringUtils.isBlank((CharSequence)keyAuthRuleHandle.getKey())) {
            Object error = ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.KEY_NAME_AND_KEY_MUST_BE_CONFIGURED);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        if (this.checkKey(exchange, keyAuthRuleHandle.getKeyName(), keyAuthRuleHandle.getKey())) {
            return chain.execute(exchange);
        }
        Object error = ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.ERROR_KEY);
        return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
    }

    private boolean checkKey(ServerWebExchange exchange, String keyName, String key) {
        HttpHeaders httpHeaders = exchange.getRequest().getHeaders();
        if (StringUtils.equals((CharSequence)httpHeaders.getFirst(keyName), (CharSequence)key)) {
            return true;
        }
        MultiValueMap multiValueMap = exchange.getRequest().getQueryParams();
        return StringUtils.equals((CharSequence)((CharSequence)multiValueMap.getFirst((Object)keyName)), (CharSequence)key);
    }
}

