/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.dubbo.config.spring.beans.factory.annotation.DubboConfigAliasPostProcessor;
import org.apache.dubbo.config.spring.beans.factory.annotation.ReferenceAnnotationBeanPostProcessor;
import org.apache.dubbo.config.spring.beans.factory.annotation.ServicePackagesHolder;
import org.apache.dubbo.config.spring.beans.factory.config.DubboConfigDefaultPropertyValueBeanPostProcessor;
import org.apache.dubbo.config.spring.context.DubboConfigApplicationListener;
import org.apache.dubbo.config.spring.context.DubboConfigBeanInitializer;
import org.apache.dubbo.config.spring.context.DubboDeployApplicationListener;
import org.apache.dubbo.config.spring.context.DubboInfraBeanRegisterPostProcessor;
import org.apache.dubbo.config.spring.context.DubboSpringInitContext;
import org.apache.dubbo.config.spring.reference.ReferenceBeanManager;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;

public interface DubboBeanUtils {
    public static final Log log = LogFactory.getLog(DubboBeanUtils.class);

    public static void registerCommonBeans(BeanDefinitionRegistry registry) {
        DubboBeanUtils.registerInfrastructureBean(registry, "dubboServicePackagesHolder", ServicePackagesHolder.class);
        DubboBeanUtils.registerInfrastructureBean(registry, "dubboReferenceBeanManager", ReferenceBeanManager.class);
        DubboBeanUtils.registerInfrastructureBean(registry, "referenceAnnotationBeanPostProcessor", ReferenceAnnotationBeanPostProcessor.class);
        DubboBeanUtils.registerInfrastructureBean(registry, "dubboConfigAliasPostProcessor", DubboConfigAliasPostProcessor.class);
        DubboBeanUtils.registerInfrastructureBean(registry, DubboDeployApplicationListener.class.getName(), DubboDeployApplicationListener.class);
        DubboBeanUtils.registerInfrastructureBean(registry, DubboConfigApplicationListener.class.getName(), DubboConfigApplicationListener.class);
        DubboBeanUtils.registerInfrastructureBean(registry, "dubboConfigDefaultPropertyValueBeanPostProcessor", DubboConfigDefaultPropertyValueBeanPostProcessor.class);
        DubboBeanUtils.registerInfrastructureBean(registry, DubboConfigBeanInitializer.BEAN_NAME, DubboConfigBeanInitializer.class);
        DubboBeanUtils.registerInfrastructureBean(registry, "dubboInfraBeanRegisterPostProcessor", DubboInfraBeanRegisterPostProcessor.class);
    }

    public static boolean registerInfrastructureBean(BeanDefinitionRegistry beanDefinitionRegistry, String beanName, Class<?> beanType) {
        boolean registered = false;
        if (!beanDefinitionRegistry.containsBeanDefinition(beanName)) {
            RootBeanDefinition beanDefinition = new RootBeanDefinition(beanType);
            beanDefinition.setRole(2);
            beanDefinitionRegistry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
            registered = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)("The Infrastructure bean definition [" + beanDefinition + "with name [" + beanName + "] has been registered."));
            }
        }
        return registered;
    }

    public static void registerPlaceholderConfigurerBeanIfNotExists(ConfigurableListableBeanFactory beanFactory, BeanDefinitionRegistry registry) {
        if (!DubboBeanUtils.checkBeanExists(beanFactory, PropertySourcesPlaceholderConfigurer.class)) {
            HashMap<String, Object> propertySourcesPlaceholderPropertyValues = new HashMap<String, Object>();
            propertySourcesPlaceholderPropertyValues.put("ignoreUnresolvablePlaceholders", true);
            DubboBeanUtils.registerBeanDefinition(registry, PropertySourcesPlaceholderConfigurer.class.getName(), PropertySourcesPlaceholderConfigurer.class, propertySourcesPlaceholderPropertyValues);
        }
    }

    public static boolean registerBeanDefinition(BeanDefinitionRegistry registry, String beanName, Class<?> beanClass, Map<String, Object> extraPropertyValues) {
        if (registry.containsBeanDefinition(beanName)) {
            return false;
        }
        AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.genericBeanDefinition(beanClass).getBeanDefinition();
        if (extraPropertyValues != null) {
            for (Map.Entry<String, Object> entry : extraPropertyValues.entrySet()) {
                beanDefinition.getPropertyValues().add(entry.getKey(), entry.getValue());
            }
        }
        registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
        return true;
    }

    public static boolean checkBeanExists(ConfigurableListableBeanFactory beanFactory, Class<?> targetClass) {
        String[] beanNames = beanFactory.getBeanNamesForType(targetClass, true, false);
        return beanNames != null && beanNames.length > 0;
    }

    public static ReferenceAnnotationBeanPostProcessor getReferenceAnnotationBeanPostProcessor(AbstractBeanFactory beanFactory) {
        for (BeanPostProcessor beanPostProcessor : beanFactory.getBeanPostProcessors()) {
            if (!(beanPostProcessor instanceof ReferenceAnnotationBeanPostProcessor)) continue;
            return (ReferenceAnnotationBeanPostProcessor)beanPostProcessor;
        }
        return null;
    }

    public static ReferenceAnnotationBeanPostProcessor getReferenceAnnotationBeanPostProcessor(ApplicationContext applicationContext) {
        return DubboBeanUtils.getReferenceAnnotationBeanPostProcessor((AbstractBeanFactory)applicationContext.getAutowireCapableBeanFactory());
    }

    public static DubboSpringInitContext getInitializationContext(BeanFactory beanFactory) {
        String beanName = DubboSpringInitContext.class.getName();
        if (beanFactory != null && beanFactory.containsBean(beanName)) {
            return (DubboSpringInitContext)beanFactory.getBean(beanName, DubboSpringInitContext.class);
        }
        return null;
    }

    public static ApplicationModel getApplicationModel(BeanFactory beanFactory) {
        String beanName = ApplicationModel.class.getName();
        if (beanFactory != null && beanFactory.containsBean(beanName)) {
            return (ApplicationModel)beanFactory.getBean(beanName, ApplicationModel.class);
        }
        return null;
    }

    public static ModuleModel getModuleModel(BeanFactory beanFactory) {
        String beanName = ModuleModel.class.getName();
        if (beanFactory != null && beanFactory.containsBean(beanName)) {
            return (ModuleModel)beanFactory.getBean(beanName, ModuleModel.class);
        }
        return null;
    }
}

