/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.support.registry;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcContextAttachment;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.ZoneDetector;
import org.apache.dubbo.rpc.cluster.ClusterInvoker;
import org.apache.dubbo.rpc.cluster.Directory;
import org.apache.dubbo.rpc.cluster.LoadBalance;
import org.apache.dubbo.rpc.cluster.support.AbstractClusterInvoker;

public class ZoneAwareClusterInvoker<T>
extends AbstractClusterInvoker<T> {
    private static final Logger logger = LoggerFactory.getLogger(ZoneAwareClusterInvoker.class);
    private ZoneDetector zoneDetector;

    public ZoneAwareClusterInvoker(Directory<T> directory) {
        super(directory);
        ExtensionLoader<ZoneDetector> loader = directory.getConsumerUrl().getOrDefaultApplicationModel().getExtensionLoader(ZoneDetector.class);
        if (loader.hasExtension("default")) {
            this.zoneDetector = loader.getExtension("default");
        }
    }

    @Override
    public Result doInvoke(Invocation invocation, List<Invoker<T>> invokers, LoadBalance loadbalance) throws RpcException {
        Invoker<T> balancedInvoker;
        for (Invoker<T> invoker2 : invokers) {
            ClusterInvoker clusterInvoker = (ClusterInvoker)invoker2;
            if (!clusterInvoker.isAvailable() || !clusterInvoker.getRegistryUrl().getParameter("preferred", false)) continue;
            return clusterInvoker.invoke(invocation);
        }
        RpcContextAttachment rpcContext = RpcContext.getClientAttachment();
        String zone = ((RpcContext)rpcContext).getAttachment("registry_zone");
        String force = ((RpcContext)rpcContext).getAttachment("registry_zone_force");
        if (StringUtils.isEmpty(zone) && this.zoneDetector != null) {
            zone = this.zoneDetector.getZoneOfCurrentRequest(invocation);
            force = this.zoneDetector.isZoneForcingEnabled(invocation, zone);
        }
        if (StringUtils.isNotEmpty(zone)) {
            for (Invoker<T> invoker3 : invokers) {
                ClusterInvoker clusterInvoker = (ClusterInvoker)invoker3;
                if (!clusterInvoker.isAvailable() || !zone.equals(clusterInvoker.getRegistryUrl().getParameter("zone"))) continue;
                return clusterInvoker.invoke(invocation);
            }
            if (StringUtils.isNotEmpty(force) && "true".equalsIgnoreCase(force)) {
                throw new IllegalStateException("No registry instance in zone or no available providers in the registry, zone: " + zone + ", registries: " + invokers.stream().map(invoker -> ((ClusterInvoker)invoker).getRegistryUrl().toString()).collect(Collectors.joining(",")));
            }
        }
        if ((balancedInvoker = this.select(loadbalance, invocation, invokers, null)) != null && balancedInvoker.isAvailable()) {
            return balancedInvoker.invoke(invocation);
        }
        for (Invoker<T> invoker4 : invokers) {
            ClusterInvoker clusterInvoker = (ClusterInvoker)invoker4;
            if (!clusterInvoker.isAvailable()) continue;
            return clusterInvoker.invoke(invocation);
        }
        throw new RpcException("No provider available in " + invokers);
    }
}

