/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.client.support;

import com.qq.tars.common.util.Loader;
import com.qq.tars.common.util.StringUtils;
import com.qq.tars.support.log.LoggerFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;

public final class ServantCacheManager {
    private static final Logger LOGGER = LoggerFactory.getClientLogger();
    private static final ServantCacheManager instance = new ServantCacheManager();
    private final Properties props = new Properties();
    private final AtomicBoolean propsInited = new AtomicBoolean();
    private final ReentrantLock lock = new ReentrantLock();

    private ServantCacheManager() {
    }

    public static ServantCacheManager getInstance() {
        return instance;
    }

    public String get(String CommunicatorId, String objName, String dataPath) {
        this.loadCacheData(dataPath);
        return this.props.getProperty(this.makeKey(CommunicatorId, objName));
    }

    private String makeKey(String CommunicatorId, String objName) {
        return objName + "@" + CommunicatorId;
    }

    public void save(String CommunicatorId, String objName, String endpointList, String dataPath) {
        try {
            this.loadCacheData(dataPath);
            this.props.remove(objName);
            this.props.put(this.makeKey(CommunicatorId, objName), endpointList);
            this.saveToLocal(dataPath);
        }
        catch (Throwable e) {
            LOGGER.error("", e);
        }
    }

    private File getCacheFile(String dataPath) throws Exception {
        String path = dataPath;
        if (StringUtils.isEmpty(path)) {
            URL url = Loader.getResource("", true);
            if (url != null) {
                path = url.getFile();
            }
            if (StringUtils.isEmpty(path)) {
                path = System.getProperty("user.dir");
            }
        }
        if (StringUtils.isEmpty(path)) {
            return null;
        }
        File f = new File(path, "tarsnodes.dat");
        if (!f.exists()) {
            f.createNewFile();
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToLocal(String dataPath) {
        this.lock.lock();
        OutputStream out = null;
        try {
            File file = this.getCacheFile(dataPath);
            if (file == null) {
                return;
            }
            out = new BufferedOutputStream(new FileOutputStream(file));
            this.props.store(out, new Date().toString());
            LOGGER.info("save " + file.getAbsolutePath());
        }
        catch (Exception e) {
            LOGGER.error("save tarsnodes.dat failed", (Throwable)e);
        }
        finally {
            if (null != out) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCacheData(String dataPath) {
        if (this.propsInited.get()) {
            return;
        }
        if (this.propsInited.compareAndSet(false, true)) {
            InputStream in = null;
            try {
                File file = this.getCacheFile(dataPath);
                if (file == null) {
                    return;
                }
                in = new BufferedInputStream(new FileInputStream(file));
                this.props.load(in);
                ArrayList<String> removeKey = new ArrayList<String>();
                for (Map.Entry<Object, Object> entry : this.props.entrySet()) {
                    if (!entry.getKey().toString().startsWith("<")) continue;
                    removeKey.add(entry.getKey().toString());
                }
                for (String key : removeKey) {
                    this.props.remove(key);
                }
                LOGGER.info("load  {}", (Object)"tarsnodes.dat");
            }
            catch (Throwable e) {
                LOGGER.error("read file tarsnodes.dat error.", e);
            }
            finally {
                if (null != in) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

