/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.sofa.handler;

import java.util.Objects;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.plugin.SofaRegisterConfig;
import org.apache.shenyu.common.dto.convert.selector.SofaUpstream;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.Singleton;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.plugin.sofa.cache.ApplicationConfigCache;

public class SofaPluginDataHandler
implements PluginDataHandler {
    public void handlerPlugin(PluginData pluginData) {
        if (Objects.nonNull(pluginData) && pluginData.getEnabled().booleanValue()) {
            SofaRegisterConfig sofaRegisterConfig = (SofaRegisterConfig)GsonUtils.getInstance().fromJson(pluginData.getConfig(), SofaRegisterConfig.class);
            if (Objects.isNull(sofaRegisterConfig)) {
                return;
            }
            SofaRegisterConfig exist = (SofaRegisterConfig)Singleton.INST.get(SofaRegisterConfig.class);
            if (Objects.isNull(exist) || !sofaRegisterConfig.equals((Object)exist)) {
                ApplicationConfigCache.getInstance().init(sofaRegisterConfig);
                ApplicationConfigCache.getInstance().invalidateAll();
            }
            Singleton.INST.single(SofaRegisterConfig.class, (Object)sofaRegisterConfig);
        }
    }

    public void handlerSelector(SelectorData selectorData) {
        SofaUpstream oCacheUpstream;
        SofaUpstream nCacheUpstreams = (SofaUpstream)GsonUtils.getInstance().fromJson(selectorData.getHandle(), SofaUpstream.class);
        if (!Objects.equals(nCacheUpstreams, oCacheUpstream = ApplicationConfigCache.getInstance().getUpstream(selectorData.getId()))) {
            ApplicationConfigCache.getInstance().invalidateWithSelectorId(selectorData.getId());
        }
    }

    public void removePlugin(PluginData pluginData) {
        ApplicationConfigCache.getInstance().invalidateAll();
    }

    public void removeSelector(SelectorData selectorData) {
        ApplicationConfigCache.getInstance().invalidateWithSelectorId(selectorData.getId());
    }

    public String pluginNamed() {
        return PluginEnum.SOFA.getName();
    }
}

