/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.mcp.server.transport;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.spec.McpError;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpServerSession;
import io.modelcontextprotocol.spec.McpServerTransport;
import io.modelcontextprotocol.spec.McpServerTransportProvider;
import io.modelcontextprotocol.util.Assert;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shenyu.plugin.mcp.server.holder.ShenyuMcpExchangeHolder;
import org.apache.shenyu.plugin.mcp.server.transport.MessageHandlingResult;
import org.apache.shenyu.plugin.mcp.server.transport.StreamableHttpProviderBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ShenyuStreamableHttpServerTransportProvider
implements McpServerTransportProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShenyuStreamableHttpServerTransportProvider.class);
    private static final String SESSION_ID_HEADER = "Mcp-Session-Id";
    private static final String JSONRPC_VERSION = "2.0";
    private static final String INITIALIZE_METHOD = "initialize";
    private static final String DEFAULT_PROTOCOL_VERSION = "2025-03-26";
    private static final String SERVER_NAME = "ShenyuMcpServer";
    private static final String SERVER_VERSION = "1.0.0";
    private final ObjectMapper objectMapper;
    private McpServerSession.Factory sessionFactory;
    private final ConcurrentHashMap<String, McpServerSession> sessions = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, StreamableHttpSessionTransport> sessionTransports = new ConcurrentHashMap();
    private volatile boolean isClosing;

    public ShenyuStreamableHttpServerTransportProvider(ObjectMapper objectMapper, String endpoint) {
        Assert.notNull((Object)objectMapper, (String)"ObjectMapper must not be null");
        Assert.notNull((Object)endpoint, (String)"Endpoint must not be null");
        this.objectMapper = objectMapper;
        LOGGER.debug("Created Streamable HTTP transport provider for endpoint: {}", (Object)endpoint);
    }

    public static StreamableHttpProviderBuilder builder() {
        return new StreamableHttpProviderBuilder();
    }

    public void setSessionFactory(McpServerSession.Factory sessionFactory) {
        this.sessionFactory = sessionFactory;
        LOGGER.debug("Session factory configured for Streamable HTTP transport");
    }

    public Mono<Void> notifyClients(String method, Object params) {
        if (this.sessions.isEmpty()) {
            LOGGER.debug("No active sessions available for client notification");
            return Mono.empty();
        }
        LOGGER.debug("Broadcasting notification '{}' to {} active sessions", (Object)method, (Object)this.sessions.size());
        return Flux.fromIterable(this.sessions.values()).flatMap(session -> session.sendNotification(method, params).doOnError(e -> LOGGER.warn("Failed to send notification to session {}: {}", (Object)session.getId(), (Object)e.getMessage())).onErrorComplete()).then().doOnSuccess(aVoid -> LOGGER.debug("Client notification broadcast completed"));
    }

    public Mono<Void> closeGracefully() {
        this.isClosing = true;
        if (this.sessions.isEmpty()) {
            LOGGER.debug("No active sessions to close during graceful shutdown");
            return Mono.empty();
        }
        LOGGER.debug("Initiating graceful shutdown of {} active sessions", (Object)this.sessions.size());
        return Flux.fromIterable(this.sessions.values()).flatMap(McpServerSession::closeGracefully).doOnComplete(() -> {
            this.sessions.clear();
            this.sessionTransports.clear();
            LOGGER.debug("Graceful shutdown completed - all sessions and transports cleared");
        }).then();
    }

    public Mono<ServerResponse> handleUnifiedEndpoint(ServerRequest request) {
        if (this.isClosing) {
            return ServerResponse.status((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE).bodyValue((Object)"Server is shutting down");
        }
        if (Objects.isNull(this.sessionFactory)) {
            LOGGER.error("SessionFactory is null - MCP server not properly initialized");
            return ServerResponse.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).bodyValue((Object)"MCP server not properly initialized");
        }
        if ("OPTIONS".equalsIgnoreCase(request.methodName())) {
            return ((ServerResponse.BodyBuilder)((ServerResponse.BodyBuilder)((ServerResponse.BodyBuilder)((ServerResponse.BodyBuilder)ServerResponse.ok().header("Access-Control-Allow-Origin", new String[]{"*"})).header("Access-Control-Allow-Headers", new String[]{"Content-Type, Mcp-Session-Id, Authorization"})).header("Access-Control-Allow-Methods", new String[]{"GET, POST, OPTIONS"})).header("Access-Control-Max-Age", new String[]{"3600"})).build();
        }
        if ("GET".equalsIgnoreCase(request.methodName())) {
            return ((ServerResponse.BodyBuilder)((ServerResponse.BodyBuilder)((ServerResponse.BodyBuilder)((ServerResponse.BodyBuilder)ServerResponse.status((HttpStatusCode)HttpStatus.METHOD_NOT_ALLOWED).header("Access-Control-Allow-Origin", new String[]{"*"})).header("Access-Control-Allow-Headers", new String[]{"Content-Type, Mcp-Session-Id, Authorization"})).header("Access-Control-Allow-Methods", new String[]{"POST, OPTIONS"})).header("Allow", new String[]{"POST, OPTIONS"})).contentType(MediaType.APPLICATION_JSON).bodyValue((Object)new HashMap<String, Object>(){
                {
                    this.put("error", new HashMap<String, Object>(){
                        {
                            this.put("code", -32601);
                            this.put("message", "Streamable HTTP does not support GET requests. Please use POST requests for all MCP operations.");
                        }
                    });
                }
            });
        }
        if ("POST".equalsIgnoreCase(request.methodName())) {
            ServerWebExchange exchange = request.exchange();
            return this.handleMessageEndpoint(exchange, request).flatMap(result -> {
                ServerResponse.BodyBuilder builder = (ServerResponse.BodyBuilder)((ServerResponse.BodyBuilder)((ServerResponse.BodyBuilder)ServerResponse.status((HttpStatusCode)HttpStatus.valueOf((int)result.getStatusCode())).header("Access-Control-Allow-Origin", new String[]{"*"})).header("Access-Control-Allow-Headers", new String[]{"Content-Type, Mcp-Session-Id, Authorization"})).header("Access-Control-Allow-Methods", new String[]{"GET, POST, OPTIONS"});
                if (Objects.nonNull(result.getSessionId())) {
                    builder.header(SESSION_ID_HEADER, new String[]{result.getSessionId()});
                }
                builder.contentType(MediaType.APPLICATION_JSON);
                return builder.bodyValue((Object)result.getResponseBodyAsJson());
            });
        }
        return ServerResponse.badRequest().bodyValue((Object)new McpError((Object)"Unsupported HTTP method"));
    }

    public Mono<MessageHandlingResult> handleMessageEndpoint(ServerWebExchange exchange, ServerRequest request) {
        LOGGER.debug("Processing Streamable HTTP message for path: {}", (Object)request.path());
        return request.bodyToMono(String.class).flatMap(body -> {
            LOGGER.debug("Received request body with length: {} chars", (Object)body.length());
            try {
                McpSchema.JSONRPCMessage message = McpSchema.deserializeJsonRpcMessage((ObjectMapper)this.objectMapper, (String)body);
                LOGGER.debug("Parsed JSON-RPC message of type: {}", (Object)message.getClass().getSimpleName());
                if (this.isInitializeRequest(message)) {
                    return this.handleInitializeRequest(exchange, message);
                }
                return this.handleRegularRequestWithEnhancement(exchange, message, request);
            }
            catch (IOException e) {
                LOGGER.warn("Failed to parse JSON-RPC message: {}", (Object)e.getMessage());
                Object errorResponse = this.createJsonRpcError(null, -32700, "Parse error: Invalid JSON-RPC message");
                return Mono.just((Object)new MessageHandlingResult(400, errorResponse, null));
            }
            catch (Exception e) {
                LOGGER.error("Unexpected error handling message: {}", (Object)e.getMessage(), (Object)e);
                Object errorResponse = this.createJsonRpcError(null, -32603, "Internal error: " + e.getMessage());
                return Mono.just((Object)new MessageHandlingResult(500, errorResponse, null));
            }
        });
    }

    private boolean isInitializeRequest(McpSchema.JSONRPCMessage message) {
        if (message instanceof McpSchema.JSONRPCRequest) {
            String method = ((McpSchema.JSONRPCRequest)message).method();
            return INITIALIZE_METHOD.equals(method);
        }
        return false;
    }

    private Mono<MessageHandlingResult> handleInitializeRequest(ServerWebExchange exchange, McpSchema.JSONRPCMessage message) {
        try {
            StreamableHttpSessionTransport transport = new StreamableHttpSessionTransport();
            McpServerSession session = this.sessionFactory.create((McpServerTransport)transport);
            String newSessionId = session.getId();
            LOGGER.debug("Created new MCP session: {}", (Object)newSessionId);
            this.sessions.put(newSessionId, session);
            this.sessionTransports.put(newSessionId, transport);
            this.configureExchangeForSession(exchange, newSessionId);
            Object messageId = this.extractMessageId(message);
            String clientProtocolVersion = this.extractProtocolVersionFromInitialize(message);
            if (!this.isSupportedProtocolVersion(clientProtocolVersion)) {
                LOGGER.warn("Unsupported protocol version requested: {}", (Object)clientProtocolVersion);
                this.cleanupInvalidSession(newSessionId);
                Object errorResponse = this.createJsonRpcError(messageId, -32600, "Unsupported protocol version. Supported versions: ['2025-03-26']");
                return Mono.just((Object)new MessageHandlingResult(400, errorResponse, null));
            }
            Object initializeResponse = this.createInitializeResponse(messageId, clientProtocolVersion, newSessionId);
            LOGGER.debug("Initialize request processed successfully for session: {}", (Object)newSessionId);
            return Mono.just((Object)new MessageHandlingResult(200, initializeResponse, newSessionId));
        }
        catch (Exception e) {
            LOGGER.error("Error handling initialize request: {}", (Object)e.getMessage(), (Object)e);
            Object errorResponse = this.createJsonRpcError(this.extractMessageId(message), -32603, "Internal error during initialization: " + e.getMessage());
            return Mono.just((Object)new MessageHandlingResult(500, errorResponse, null));
        }
    }

    private Mono<MessageHandlingResult> handleRegularRequestWithEnhancement(ServerWebExchange exchange, McpSchema.JSONRPCMessage message, ServerRequest request) {
        String requestedSessionId = this.extractSessionId(request);
        Object messageId = this.extractMessageId(message);
        if (Objects.isNull(requestedSessionId)) {
            LOGGER.info("No sessionId provided, creating temporary session for request");
            return this.createTemporarySessionAndProcess(exchange, message, messageId);
        }
        McpServerSession existingSession = this.sessions.get(requestedSessionId);
        if (Objects.isNull(existingSession)) {
            LOGGER.info("SessionId {} not found, creating new session and re-storing", (Object)requestedSessionId);
            return this.createSessionAndRestoreId(exchange, message, requestedSessionId, messageId);
        }
        LOGGER.debug("Processing request for existing session: {}", (Object)requestedSessionId);
        ServerWebExchange existingExchange = ShenyuMcpExchangeHolder.get(requestedSessionId);
        LOGGER.debug("Checking exchange mapping for session {}: existing={}", (Object)requestedSessionId, Objects.nonNull(existingExchange) ? "present (ID: " + System.identityHashCode(existingExchange) + ")" : "null");
        if (Objects.isNull(ShenyuMcpExchangeHolder.get(requestedSessionId))) {
            LOGGER.info("Exchange mapping lost for session {}, re-binding new exchange (ID: {})", (Object)requestedSessionId, (Object)System.identityHashCode(exchange));
            this.configureExchangeForSession(exchange, requestedSessionId);
            LOGGER.info("Re-bound ServerWebExchange to session {} after reconnect", (Object)requestedSessionId);
        } else {
            LOGGER.debug("Exchange mapping already exists for session {}, using existing exchange", (Object)requestedSessionId);
        }
        return this.processWithExistingSession(existingSession, requestedSessionId, message, messageId).map(result -> {
            if (!requestedSessionId.equals(result.getSessionId())) {
                LOGGER.info("Returning actual session ID {} instead of requested ID {}", (Object)result.getSessionId(), (Object)requestedSessionId);
                return new MessageHandlingResult(result.getStatusCode(), result.getResponseBody(), result.getSessionId());
            }
            return result;
        });
    }

    private Mono<MessageHandlingResult> createTemporarySessionAndProcess(ServerWebExchange exchange, McpSchema.JSONRPCMessage message, Object messageId) {
        try {
            StreamableHttpSessionTransport tempTransport = new StreamableHttpSessionTransport();
            McpServerSession tempSession = this.sessionFactory.create((McpServerTransport)tempTransport);
            String actualSessionId = tempSession.getId();
            LOGGER.info("Created temporary session: {}", (Object)actualSessionId);
            this.sessions.put(actualSessionId, tempSession);
            this.sessionTransports.put(actualSessionId, tempTransport);
            this.configureExchangeForSession(exchange, actualSessionId);
            LOGGER.debug("Bound exchange to temporary session: {} before handshake", (Object)actualSessionId);
            this.initializeSessionDirectly(tempSession, actualSessionId);
            tempTransport.resetCapturedMessage();
            return this.processWithExistingSession(tempSession, actualSessionId, message, messageId).doFinally(signalType -> {
                LOGGER.debug("Cleaning up temporary session: {} (signal: {})", (Object)actualSessionId, signalType);
                this.removeSession(actualSessionId);
                ShenyuMcpExchangeHolder.remove(actualSessionId);
            }).map(result -> new MessageHandlingResult(result.getStatusCode(), result.getResponseBody(), null));
        }
        catch (Exception e) {
            LOGGER.error("Error creating temporary session: {}", (Object)e.getMessage(), (Object)e);
            Object errorResponse = this.createJsonRpcError(messageId, -32603, "Internal error creating temporary session: " + e.getMessage());
            return Mono.just((Object)new MessageHandlingResult(500, errorResponse, null));
        }
    }

    private Mono<MessageHandlingResult> createSessionAndRestoreId(ServerWebExchange exchange, McpSchema.JSONRPCMessage message, String requestedSessionId, Object messageId) {
        try {
            StreamableHttpSessionTransport newTransport = new StreamableHttpSessionTransport(requestedSessionId);
            McpServerSession newSession = this.sessionFactory.create((McpServerTransport)newTransport);
            String actualSessionId = newSession.getId();
            LOGGER.info("Created new session - requested ID: {}, actual ID: {}", (Object)requestedSessionId, (Object)actualSessionId);
            this.sessions.put(actualSessionId, newSession);
            this.sessionTransports.put(actualSessionId, newTransport);
            this.configureExchangeForSession(exchange, actualSessionId);
            LOGGER.debug("Bound exchange to restored session: {} before handshake", (Object)actualSessionId);
            this.initializeSessionDirectly(newSession, actualSessionId);
            newTransport.resetCapturedMessage();
            return this.processWithExistingSession(newSession, actualSessionId, message, messageId).map(result -> {
                if (!actualSessionId.equals(requestedSessionId)) {
                    LOGGER.info("Returning actual session ID {} instead of requested ID {}", (Object)actualSessionId, (Object)requestedSessionId);
                    return new MessageHandlingResult(result.getStatusCode(), result.getResponseBody(), actualSessionId);
                }
                return result;
            });
        }
        catch (Exception e) {
            LOGGER.error("Error creating session with restored ID {}: {}", new Object[]{requestedSessionId, e.getMessage(), e});
            Object errorResponse = this.createJsonRpcError(messageId, -32603, "Internal error restoring session: " + e.getMessage());
            return Mono.just((Object)new MessageHandlingResult(500, errorResponse, requestedSessionId));
        }
    }

    private Mono<MessageHandlingResult> processWithExistingSession(McpServerSession session, String sessionId, McpSchema.JSONRPCMessage message, Object messageId) {
        ServerWebExchange verifyExchange = ShenyuMcpExchangeHolder.get(sessionId);
        if (Objects.isNull(verifyExchange)) {
            LOGGER.error("CRITICAL: No exchange found in ShenyuMcpExchangeHolder for session {} when processing business request. This will cause ToolCallback to fail.", (Object)sessionId);
        } else {
            LOGGER.debug("Exchange verification passed for session {} (exchange ID: {})", (Object)sessionId, (Object)System.identityHashCode(verifyExchange));
        }
        StreamableHttpSessionTransport transport = this.getSessionTransport(sessionId);
        return session.handle(message).cast(Object.class).doOnSuccess(result -> LOGGER.debug("Successfully processed message for session: {}", (Object)sessionId)).then(this.waitForTransportResponse(transport, sessionId, messageId)).onErrorResume(error -> {
            LOGGER.error("Error processing message for session {}: {}", new Object[]{sessionId, error.getMessage(), error});
            Object errorResponse = this.createJsonRpcError(messageId, -32603, "Internal error: " + error.getMessage());
            return Mono.just((Object)new MessageHandlingResult(500, errorResponse, sessionId));
        });
    }

    private void configureExchangeForSession(ServerWebExchange exchange, String sessionId) {
        if (Objects.isNull(exchange)) {
            LOGGER.error("Attempted to configure null exchange for session: {}", (Object)sessionId);
            return;
        }
        exchange.getAttributes().put("MCP_SESSION_ID", sessionId);
        ShenyuMcpExchangeHolder.put(sessionId, exchange);
        ServerWebExchange storedExchange = ShenyuMcpExchangeHolder.get(sessionId);
        if (Objects.isNull(storedExchange)) {
            LOGGER.error("Failed to store exchange in ShenyuMcpExchangeHolder for session: {}", (Object)sessionId);
        } else {
            LOGGER.info("Successfully configured and stored exchange for session: {} (exchange ID: {})", (Object)sessionId, (Object)System.identityHashCode(exchange));
        }
    }

    private void cleanupInvalidSession(String sessionId) {
        this.sessions.remove(sessionId);
        this.sessionTransports.remove(sessionId);
        LOGGER.debug("Cleaned up invalid session: {}", (Object)sessionId);
    }

    private String extractProtocolVersionFromInitialize(McpSchema.JSONRPCMessage message) {
        Object params;
        if (message instanceof McpSchema.JSONRPCRequest && (params = ((McpSchema.JSONRPCRequest)message).params()) instanceof Map) {
            Map paramsMap = (Map)params;
            Object protocolVersion = paramsMap.get("protocolVersion");
            return Objects.nonNull(protocolVersion) ? protocolVersion.toString() : DEFAULT_PROTOCOL_VERSION;
        }
        return DEFAULT_PROTOCOL_VERSION;
    }

    private boolean isSupportedProtocolVersion(String version) {
        return DEFAULT_PROTOCOL_VERSION.equals(version);
    }

    private Object createInitializeResponse(Object messageId, String protocolVersion, String sessionId) {
        HashMap capabilities = new HashMap();
        HashMap<String, Boolean> toolsCapability = new HashMap<String, Boolean>();
        toolsCapability.put("listChanged", true);
        capabilities.put("tools", toolsCapability);
        HashMap<String, String> serverInfo = new HashMap<String, String>();
        serverInfo.put("name", SERVER_NAME);
        serverInfo.put("version", SERVER_VERSION);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("protocolVersion", protocolVersion);
        result.put("capabilities", capabilities);
        result.put("serverInfo", serverInfo);
        result.put("instructions", "Use available tools to interact with Shenyu gateway services");
        result.put("sessionId", sessionId);
        return this.createJsonRpcResponse(messageId, result);
    }

    private Object extractMessageId(McpSchema.JSONRPCMessage message) {
        if (message instanceof McpSchema.JSONRPCRequest) {
            return ((McpSchema.JSONRPCRequest)message).id();
        }
        return null;
    }

    private Object createJsonRpcResponse(Object id, Object result) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("jsonrpc", JSONRPC_VERSION);
        if (Objects.nonNull(id)) {
            response.put("id", id);
        }
        response.put("result", Objects.nonNull(result) ? result : new HashMap());
        return response;
    }

    private Object createJsonRpcError(Object id, int code, String message) {
        HashMap<String, Object> error = new HashMap<String, Object>();
        error.put("code", code);
        error.put("message", message);
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("jsonrpc", JSONRPC_VERSION);
        if (Objects.nonNull(id)) {
            response.put("id", id);
        }
        response.put("error", error);
        return response;
    }

    private String extractSessionId(ServerRequest request) {
        String sessionId = request.queryParam("sessionId").orElse(null);
        if (Objects.nonNull(sessionId)) {
            return sessionId;
        }
        return request.headers().firstHeader(SESSION_ID_HEADER);
    }

    public void removeSession(String sessionId) {
        McpServerSession removedSession = this.sessions.remove(sessionId);
        StreamableHttpSessionTransport removedTransport = this.sessionTransports.remove(sessionId);
        if (Objects.nonNull(removedSession) || Objects.nonNull(removedTransport)) {
            LOGGER.debug("Removed session and transport: {}", (Object)sessionId);
        }
    }

    private StreamableHttpSessionTransport getSessionTransport(String sessionId) {
        return this.sessionTransports.get(sessionId);
    }

    private Mono<MessageHandlingResult> waitForTransportResponse(StreamableHttpSessionTransport transport, String sessionId, Object messageId) {
        return Mono.fromCallable(() -> {
            if (Objects.nonNull(transport) && transport.isResponseReady() && Objects.nonNull(transport.getLastSentMessage())) {
                McpSchema.JSONRPCMessage sentMessage = transport.getLastSentMessage();
                LOGGER.debug("Retrieved captured response from transport for session: {}", (Object)sessionId);
                return new MessageHandlingResult(200, sentMessage, sessionId);
            }
            LOGGER.debug("No response captured from transport, returning default success for session: {}", (Object)sessionId);
            Object successResponse = this.createJsonRpcResponse(messageId, new HashMap());
            return new MessageHandlingResult(200, successResponse, sessionId);
        });
    }

    private void initializeSessionDirectly(McpServerSession session, String sessionId) {
        try {
            LOGGER.debug("Starting backend initialization for session: {}", (Object)sessionId);
            String initRequestJson = this.createInitializeRequest();
            McpSchema.JSONRPCMessage initRequest = McpSchema.deserializeJsonRpcMessage((ObjectMapper)this.objectMapper, (String)initRequestJson);
            LOGGER.debug("Created initialize request for session: {}", (Object)sessionId);
            session.handle(initRequest).doOnSuccess(v -> {
                LOGGER.debug("Initialize request processed successfully for session: {}", (Object)sessionId);
                try {
                    StreamableHttpSessionTransport transport = this.sessionTransports.get(sessionId);
                    if (Objects.nonNull(transport) && transport.isResponseReady()) {
                        LOGGER.debug("Initialize response captured, session {} should be ready", (Object)sessionId);
                        this.completeInitializationHandshakeAsync(session, sessionId);
                    } else {
                        LOGGER.warn("No initialize response captured for session: {}", (Object)sessionId);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error checking initialize response for session {}: {}", (Object)sessionId, (Object)e.getMessage());
                }
            }).doOnError(e -> LOGGER.error("Failed to process initialize request for session {}: {}", new Object[]{sessionId, e.getMessage(), e})).subscribe();
            LOGGER.debug("Backend initialization completed for session: {}", (Object)sessionId);
            if (this.verifySessionInitialized(session, sessionId)) {
                LOGGER.info("Session {} successfully initialized and ready for business requests", (Object)sessionId);
            } else {
                LOGGER.warn("Session {} initialization may be incomplete - proceeding anyway", (Object)sessionId);
            }
        }
        catch (Exception e2) {
            LOGGER.error("Unexpected error during session initialization for {}: {}", new Object[]{sessionId, e2.getMessage(), e2});
        }
    }

    private String createInitializeRequest() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("protocolVersion", DEFAULT_PROTOCOL_VERSION);
        params.put("capabilities", new HashMap<String, Object>(){
            {
                this.put("roots", new ArrayList());
            }
        });
        params.put("clientInfo", new HashMap<String, Object>(){
            {
                this.put("name", "ShenyuMcpClient");
                this.put("version", ShenyuStreamableHttpServerTransportProvider.SERVER_VERSION);
            }
        });
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("jsonrpc", JSONRPC_VERSION);
        request.put("id", "__backend_init");
        request.put("method", INITIALIZE_METHOD);
        request.put("params", params);
        try {
            return this.objectMapper.writeValueAsString(request);
        }
        catch (Exception e) {
            LOGGER.error("Failed to create initialize request JSON: {}", (Object)e.getMessage());
            return "{\"jsonrpc\":\"2.0\",\"id\":\"__backend_init\",\"method\":\"initialize\",\"params\":{\"protocolVersion\":\"2025-03-26\"}}";
        }
    }

    private boolean verifySessionInitialized(McpServerSession session, String sessionId) {
        try {
            try {
                Field initializedField = session.getClass().getDeclaredField("initialized");
                initializedField.setAccessible(true);
                Object value = initializedField.get(session);
                boolean isInitialized = Boolean.TRUE.equals(value);
                LOGGER.debug("Session {} initialized field value: {}", (Object)sessionId, (Object)isInitialized);
                return isInitialized;
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                LOGGER.debug("No 'initialized' field found or accessible in session: {}", (Object)e.getMessage());
                try {
                    Field stateField = session.getClass().getDeclaredField("state");
                    stateField.setAccessible(true);
                    Object stateValue = stateField.get(session);
                    if (Objects.nonNull(stateValue)) {
                        String stateStr = stateValue.toString().toLowerCase();
                        boolean isInitialized = stateStr.contains("init") && !stateStr.contains("uninit");
                        LOGGER.debug("Session {} state value: {} (initialized: {})", new Object[]{sessionId, stateValue, isInitialized});
                        return isInitialized;
                    }
                }
                catch (IllegalAccessException | NoSuchFieldException e2) {
                    LOGGER.debug("No 'state' field found or accessible in session: {}", (Object)e2.getMessage());
                }
                StreamableHttpSessionTransport transport = this.sessionTransports.get(sessionId);
                if (Objects.nonNull(transport)) {
                    boolean hasResponse = transport.isResponseReady();
                    LOGGER.debug("Session {} transport has response ready: {}", (Object)sessionId, (Object)hasResponse);
                    return hasResponse;
                }
                LOGGER.debug("Unable to verify initialization state for session: {}", (Object)sessionId);
                return false;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error verifying session initialization for {}: {}", (Object)sessionId, (Object)e.getMessage());
            return false;
        }
    }

    private void completeInitializationHandshakeAsync(McpServerSession session, String sessionId) {
        block9: {
            try {
                try {
                    HashMap<String, Object> notification = new HashMap<String, Object>();
                    notification.put("jsonrpc", JSONRPC_VERSION);
                    notification.put("method", "notifications/initialized");
                    notification.put("params", new HashMap());
                    String notificationJson = this.objectMapper.writeValueAsString(notification);
                    McpSchema.JSONRPCMessage notificationMessage = McpSchema.deserializeJsonRpcMessage((ObjectMapper)this.objectMapper, (String)notificationJson);
                    session.handle(notificationMessage).doOnSuccess(v -> LOGGER.debug("Initialized notification sent successfully for session: {}", (Object)sessionId)).doOnError(e -> LOGGER.debug("Initialized notification failed for session {}: {}", (Object)sessionId, (Object)e.getMessage())).onErrorComplete().subscribe();
                }
                catch (Exception e2) {
                    LOGGER.debug("Strategy 1 failed: {}", (Object)e2.getMessage());
                }
                try {
                    Field initializedField = session.getClass().getDeclaredField("initialized");
                    initializedField.setAccessible(true);
                    initializedField.set(session, true);
                    LOGGER.debug("Successfully set session {} to initialized state via reflection", (Object)sessionId);
                }
                catch (Exception e3) {
                    LOGGER.debug("Strategy 2 failed: {}", (Object)e3.getMessage());
                }
                try {
                    Field stateField = session.getClass().getDeclaredField("state");
                    stateField.setAccessible(true);
                    Object stateValue = stateField.get(session);
                    if (!Objects.nonNull(stateValue) || !stateValue.getClass().isEnum()) break block9;
                    for (Object enumConstant : stateValue.getClass().getEnumConstants()) {
                        if (!enumConstant.toString().toLowerCase().contains("init") || enumConstant.toString().toLowerCase().contains("uninit")) continue;
                        stateField.set(session, enumConstant);
                        LOGGER.debug("Successfully set session {} state to {} via reflection", (Object)sessionId, enumConstant);
                        break;
                    }
                }
                catch (Exception e4) {
                    LOGGER.debug("Strategy 3 failed: {}", (Object)e4.getMessage());
                }
            }
            catch (Exception e5) {
                LOGGER.error("Error completing handshake for session {}: {}", new Object[]{sessionId, e5.getMessage(), e5});
            }
        }
    }

    private class StreamableHttpSessionTransport
    implements McpServerTransport {
        private final String sessionId;
        private volatile boolean closed;
        private volatile McpSchema.JSONRPCMessage lastSentMessage;
        private volatile boolean responseReady;

        StreamableHttpSessionTransport() {
            this.sessionId = UUID.randomUUID().toString();
            LOGGER.debug("Created StreamableHttpSessionTransport with auto-generated sessionId: {}", (Object)this.sessionId);
        }

        StreamableHttpSessionTransport(String sessionId) {
            this.sessionId = Objects.nonNull(sessionId) ? sessionId : UUID.randomUUID().toString();
            LOGGER.debug("Created StreamableHttpSessionTransport with sessionId: {}", (Object)this.sessionId);
        }

        public McpSchema.JSONRPCMessage getLastSentMessage() {
            return this.lastSentMessage;
        }

        public boolean isResponseReady() {
            return this.responseReady;
        }

        public Mono<Void> sendMessage(McpSchema.JSONRPCMessage message) {
            if (!this.closed) {
                this.lastSentMessage = message;
                this.responseReady = true;
                LOGGER.debug("Captured response message for session: {}", (Object)this.sessionId);
            }
            return Mono.empty();
        }

        public <T> T unmarshalFrom(Object data, TypeReference<T> typeRef) {
            try {
                return (T)new ObjectMapper().convertValue(data, typeRef);
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }

        public Mono<Void> closeGracefully() {
            return Mono.fromRunnable(() -> {
                if (!this.closed) {
                    this.closed = true;
                    ShenyuStreamableHttpServerTransportProvider.this.removeSession(this.sessionId);
                    LOGGER.debug("Session transport closed gracefully: {}", (Object)this.sessionId);
                }
            });
        }

        public void close() {
            if (!this.closed) {
                this.closed = true;
                ShenyuStreamableHttpServerTransportProvider.this.removeSession(this.sessionId);
                LOGGER.debug("Session transport closed immediately: {}", (Object)this.sessionId);
            }
        }

        public void resetCapturedMessage() {
            this.lastSentMessage = null;
            this.responseReady = false;
        }
    }
}

