/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.reactor;

import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.adapter.reactor.ContextConfig;
import com.alibaba.csp.sentinel.util.AssertUtil;
import java.util.Arrays;

public class EntryConfig {
    private final String resourceName;
    private final EntryType entryType;
    private final int resourceType;
    private final int acquireCount;
    private final Object[] args;
    private final ContextConfig contextConfig;

    public EntryConfig(String resourceName) {
        this(resourceName, EntryType.OUT);
    }

    public EntryConfig(String resourceName, EntryType entryType) {
        this(resourceName, entryType, null);
    }

    public EntryConfig(String resourceName, EntryType entryType, ContextConfig contextConfig) {
        this(resourceName, entryType, 1, new Object[0], contextConfig);
    }

    public EntryConfig(String resourceName, int resourceType, EntryType entryType, ContextConfig contextConfig) {
        this(resourceName, resourceType, entryType, 1, new Object[0], contextConfig);
    }

    public EntryConfig(String resourceName, EntryType entryType, int acquireCount, Object[] args) {
        this(resourceName, entryType, acquireCount, args, null);
    }

    public EntryConfig(String resourceName, EntryType entryType, int acquireCount, Object[] args, ContextConfig contextConfig) {
        this(resourceName, 0, entryType, acquireCount, args, contextConfig);
    }

    public EntryConfig(String resourceName, int resourceType, EntryType entryType, int acquireCount, Object[] args) {
        this(resourceName, resourceType, entryType, acquireCount, args, null);
    }

    public EntryConfig(String resourceName, int resourceType, EntryType entryType, int acquireCount, Object[] args, ContextConfig contextConfig) {
        AssertUtil.assertNotBlank((String)resourceName, (String)"resourceName cannot be blank");
        AssertUtil.notNull((Object)entryType, (String)"entryType cannot be null");
        AssertUtil.isTrue((acquireCount > 0 ? 1 : 0) != 0, (String)"acquireCount should be positive");
        this.resourceName = resourceName;
        this.entryType = entryType;
        this.resourceType = resourceType;
        this.acquireCount = acquireCount;
        this.args = args;
        this.contextConfig = contextConfig;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public EntryType getEntryType() {
        return this.entryType;
    }

    public int getAcquireCount() {
        return this.acquireCount;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public ContextConfig getContextConfig() {
        return this.contextConfig;
    }

    public int getResourceType() {
        return this.resourceType;
    }

    public String toString() {
        return "EntryConfig{resourceName='" + this.resourceName + '\'' + ", entryType=" + this.entryType + ", resourceType=" + this.resourceType + ", acquireCount=" + this.acquireCount + ", args=" + Arrays.toString(this.args) + ", contextConfig=" + this.contextConfig + '}';
    }
}

