/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.ai.proxy.enhanced.subscriber;

import java.util.Objects;
import org.apache.shenyu.common.dto.ProxyApiKeyData;
import org.apache.shenyu.plugin.ai.proxy.enhanced.cache.AiProxyApiKeyCache;
import org.apache.shenyu.plugin.ai.proxy.enhanced.cache.ChatClientCache;
import org.apache.shenyu.sync.data.api.AiProxyApiKeyDataSubscriber;

public final class CommonAiProxyApiKeyDataSubscriber
implements AiProxyApiKeyDataSubscriber {
    private final ChatClientCache chatClientCache;

    public CommonAiProxyApiKeyDataSubscriber(ChatClientCache chatClientCache) {
        this.chatClientCache = chatClientCache;
    }

    public void onSubscribe(ProxyApiKeyData data) {
        if (Objects.isNull(data) || Objects.isNull(data.getProxyApiKey())) {
            return;
        }
        AiProxyApiKeyCache.getInstance().cache(data);
    }

    public void unSubscribe(ProxyApiKeyData data) {
        if (Objects.isNull(data) || Objects.isNull(data.getProxyApiKey())) {
            return;
        }
        AiProxyApiKeyCache.getInstance().remove(data);
    }

    public void refresh() {
        AiProxyApiKeyCache.getInstance().refresh();
        this.chatClientCache.clearAll();
    }
}

