/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.lookout.api;

import com.alipay.lookout.api.Id;
import com.alipay.lookout.api.Measurement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class Indicator<T> {
    private final long timestamp;
    private final Id id;
    private final Set<Measurement<T>> measurements;

    public Indicator(long timestamp, Id id) {
        this.timestamp = timestamp;
        this.id = id;
        this.measurements = new HashSet<Measurement<T>>();
    }

    public Indicator(long timestamp, Id id, T value) {
        this.timestamp = timestamp;
        this.id = id;
        this.measurements = Collections.singleton(new Measurement<T>(value));
    }

    public Indicator addMeasurement(String name, T value) {
        this.measurements.add(new Measurement<T>(name, value));
        return this;
    }

    public Indicator addMeasurement(Measurement measurement) {
        this.measurements.add(measurement);
        return this;
    }

    public Id id() {
        return this.id;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Collection<Measurement<T>> measurements() {
        return this.measurements;
    }
}

