/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.internal.LettuceAssert;

public class GeoCoordinates {
    private final Number x;
    private final Number y;

    public GeoCoordinates(Number x, Number y) {
        LettuceAssert.notNull((Object)x, "X must not be null");
        LettuceAssert.notNull((Object)y, "Y must not be null");
        this.x = x;
        this.y = y;
    }

    public static GeoCoordinates create(Number x, Number y) {
        return new GeoCoordinates(x, y);
    }

    public Number getX() {
        return this.x;
    }

    public Number getY() {
        return this.y;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GeoCoordinates)) {
            return false;
        }
        GeoCoordinates geoCoords = (GeoCoordinates)o;
        if (this.x != null ? !this.x.equals(geoCoords.x) : geoCoords.x != null) {
            return false;
        }
        return !(this.y == null ? geoCoords.y != null : !this.y.equals(geoCoords.y));
    }

    public int hashCode() {
        int result = this.x != null ? this.x.hashCode() : 0;
        result = 31 * result + (this.y != null ? this.y.hashCode() : 0);
        return result;
    }

    public String toString() {
        return String.format("(%s, %s)", this.getX(), this.getY());
    }
}

